/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLScriptItemAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionSet;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.CommonUtils;

public abstract class SQLQueryCompletionContext {
    private static final Log log = Log.getLog(SQLQueryCompletionContext.class);
    private static final Set<String> statementStartKeywords = LSMInspections.prepareOffquerySyntaxInspection().predictedWords;
    private static final Collection<SQLQueryCompletionItem> statementStartKeywordCompletions = statementStartKeywords.stream().sorted().map(SQLQueryCompletionItem::forReservedWord).toList();
    private static final int statementStartKeywordMaxLength = statementStartKeywords.stream().mapToInt(String::length).max().orElse(0);
    public static final SQLQueryCompletionContext EMPTY = new SQLQueryCompletionContext(0){

        @Override
        @Nullable
        public SQLQueryDataContext getDataContext() {
            return null;
        }

        @Override
        @NotNull
        public LSMInspections.SyntaxInspectionResult getInspectionResult() {
            return LSMInspections.SyntaxInspectionResult.EMPTY;
        }

        @Override
        @NotNull
        public SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor monitor, int position, @NotNull SQLCompletionRequest request) {
            return new SQLQueryCompletionSet(position, 0, Collections.emptyList());
        }
    };
    private final int scriptItemOffset;

    public static int getMaxKeywordLength() {
        return statementStartKeywordMaxLength;
    }

    @NotNull
    public static SQLQueryCompletionContext prepareOffquery(int scriptItemOffset) {
        return new SQLQueryCompletionContext(scriptItemOffset){
            private static final LSMInspections.SyntaxInspectionResult syntaxInspectionResult = LSMInspections.prepareOffquerySyntaxInspection();

            @Override
            @Nullable
            public SQLQueryDataContext getDataContext() {
                return null;
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return syntaxInspectionResult;
            }

            @Override
            @NotNull
            public SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor monitor, int position, @NotNull SQLCompletionRequest request) {
                return new SQLQueryCompletionSet(position, 0, statementStartKeywordCompletions);
            }
        };
    }

    private SQLQueryCompletionContext(int scriptItemOffset) {
        this.scriptItemOffset = scriptItemOffset;
    }

    public int getOffset() {
        return this.scriptItemOffset;
    }

    @Nullable
    public abstract SQLQueryDataContext getDataContext();

    @NotNull
    public abstract LSMInspections.SyntaxInspectionResult getInspectionResult();

    @NotNull
    public Set<String> getAliasesInUse() {
        return Collections.emptySet();
    }

    @NotNull
    public abstract SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor var1, int var2, @NotNull SQLCompletionRequest var3);

    public static SQLQueryCompletionContext prepare(@NotNull SQLScriptItemAtOffset scriptItem, final @Nullable DBCExecutionContext dbcExecutionContext, final @NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult, final @NotNull SQLQueryDataContext context, final @Nullable SQLQueryLexicalScopeItem lexicalItem, final @NotNull STMTreeTermNode[] nameNodes) {
        return new SQLQueryCompletionContext(scriptItem.offset){
            private final Map<SQLQueryRowsSourceModel, SourceResolutionResult> referencedSources;
            private Set<String> aliasesInUse;
            {
                super($anonymous0);
                this.referencedSources = sQLQueryDataContext.collectKnownSources().getResolutionResults();
                this.aliasesInUse = null;
            }

            @Override
            @NotNull
            public SQLQueryDataContext getDataContext() {
                return context;
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return syntaxInspectionResult;
            }

            @Override
            @NotNull
            public Set<String> getAliasesInUse() {
                if (this.aliasesInUse == null) {
                    this.aliasesInUse = this.referencedSources.values().stream().map(srr -> srr.aliasOrNull).filter(Objects::nonNull).map(SQLQuerySymbol::getName).collect(Collectors.toSet());
                }
                return this.aliasesInUse;
            }

            @Override
            @NotNull
            public SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor monitor, int position, @NotNull SQLCompletionRequest request) {
                List tableRefCompletions;
                String currentWord = this.obtainCurrentWord(position -= this.getOffset());
                List keywordCompletions = nameNodes.length > 1 ? Collections.emptyList() : this.prepareKeywordCompletions(syntaxInspectionResult.predictedWords, currentWord);
                List columnRefCompletions = syntaxInspectionResult.expectingColumnReference && nameNodes.length == 0 ? this.prepareColumnCompletions(null) : Collections.emptyList();
                List<Object> list = tableRefCompletions = syntaxInspectionResult.expectingTableReference && nameNodes.length == 0 ? this.prepareTableCompletions(monitor, request) : Collections.emptyList();
                List<SQLQueryCompletionItem> lexicalItemCompletions = lexicalItem != null ? this.prepareLexicalItemCompletions(monitor, lexicalItem, position) : (syntaxInspectionResult.expectingIdentifier || nameNodes.length > 0 ? this.prepareIdentifierCompletions(monitor, position) : Collections.emptyList());
                List<SQLQueryCompletionItem> completionItems = Stream.of(columnRefCompletions, tableRefCompletions, lexicalItemCompletions, keywordCompletions).flatMap(Collection::stream).collect(Collectors.toList());
                int replacementLength = currentWord == null ? 0 : currentWord.length();
                return new SQLQueryCompletionSet(position - replacementLength, replacementLength, completionItems);
            }

            @Nullable
            private String obtainCurrentWord(int position) {
                if (nameNodes.length == 0) {
                    return null;
                }
                STMTreeTermNode lastNode = nameNodes[nameNodes.length - 1];
                Interval wordRange = lastNode.getRealInterval();
                if (wordRange.b >= position - 1 && lastNode.symbol.getType() != 175) {
                    return lastNode.getTextContent().substring(0, position - lastNode.getRealInterval().a);
                }
                return null;
            }

            @NotNull
            private List<SQLQueryCompletionItem> prepareIdentifierCompletions(@NotNull DBRProgressMonitor monitor, int position) {
                List<String> parts = this.obtainIdentifierParts(position);
                return this.prepareIdentifierCompletions(monitor, parts, null);
            }

            private List<SQLQueryCompletionItem> prepareIdentifierCompletions(@NotNull DBRProgressMonitor monitor, @NotNull List<String> parts, Class<?> componentType) {
                List<String> prefix = parts.subList(0, parts.size() - 1);
                String tail = parts.get(parts.size() - 1);
                List<SQLQueryCompletionItem> result = !CommonUtils.isEmpty((String)tail) ? (syntaxInspectionResult.expectingColumnReference ? this.accomplishColumnReference(prefix, tail) : (syntaxInspectionResult.expectingTableReference ? this.accomplishTableReference(monitor, componentType, prefix, tail) : Collections.emptyList())) : Collections.emptyList();
                return result;
            }

            @NotNull
            private List<SQLQueryCompletionItem> accomplishTableReference(@NotNull DBRProgressMonitor monitor, @NotNull Class<?> componentType, @NotNull List<String> prefix, @NotNull String tail) {
                if (dbcExecutionContext == null || dbcExecutionContext.getDataSource() == null || !DBStructUtils.isConnectedContainer((DBPObject)dbcExecutionContext.getDataSource())) {
                    return Collections.emptyList();
                }
                DBSObject prefixContext = prefix.size() == 0 ? DBUtils.getSelectedObject((DBCExecutionContext)dbcExecutionContext) : SQLSearchUtils.findObjectByFQN(monitor, (DBSObjectContainer)dbcExecutionContext.getDataSource(), dbcExecutionContext, prefix, false, new SQLIdentifierDetector(dbcExecutionContext.getDataSource().getSQLDialect()));
                return prefixContext == null ? Collections.emptyList() : this.prepareObjectComponentCompletions(monitor, prefixContext, tail, componentType);
            }

            @NotNull
            private List<SQLQueryCompletionItem> accomplishColumnReference(@NotNull List<String> prefix, @NotNull String tail) {
                if (prefix.size() == 1) {
                    String mayBeAliasName = prefix.get(0).toLowerCase();
                    SourceResolutionResult srr = this.referencedSources.values().stream().filter(rr -> rr.aliasOrNull != null && rr.aliasOrNull.getName().toLowerCase().contains(mayBeAliasName)).findFirst().orElse(null);
                    if (srr != null) {
                        return srr.source.getResultDataContext().getColumnsList().stream().filter(c -> c.symbol.getName().toLowerCase().contains(tail)).map(c -> SQLQueryCompletionItem.forSubsetColumn(c, srr, false)).toList();
                    }
                } else if (prefix.size() == 0) {
                    return this.prepareColumnCompletions(tail);
                }
                return Collections.emptyList();
            }

            @NotNull
            private List<SQLQueryCompletionItem> prepareObjectComponentCompletions(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String componentNamePart, Class<?> componentType) {
                try {
                    DBSObjectContainer container;
                    DBSEntity entity;
                    List attrs;
                    Stream<Object> components = object instanceof DBSEntity ? ((attrs = (entity = (DBSEntity)object).getAttributes(monitor)) != null ? attrs.stream() : Stream.empty()) : (object instanceof DBSObjectContainer && DBStructUtils.isConnectedContainer((DBPObject)(container = (DBSObjectContainer)object)) ? container.getChildren(monitor).stream() : Stream.empty());
                    return components.filter(a -> (componentType == null || componentType.isInstance(a)) && a.getName().toLowerCase().contains(componentNamePart)).map(SQLQueryCompletionItem::forDbObject).toList();
                }
                catch (DBException dBException) {
                    return Collections.emptyList();
                }
            }

            private List<String> obtainIdentifierParts(int position) {
                ArrayList<String> parts = new ArrayList<String>(nameNodes.length);
                int i = 0;
                while (i < nameNodes.length) {
                    STMTreeTermNode term = nameNodes[i];
                    if (term.symbol.getType() != 175) {
                        if (term.getRealInterval().b + 1 >= position) break;
                        parts.add(term.getTextContent().toLowerCase());
                    }
                    ++i;
                }
                STMTreeTermNode currentNode = i >= nameNodes.length ? null : nameNodes[i];
                String currentPart = currentNode == null ? "" : currentNode.getTextContent().substring(0, position - currentNode.getRealInterval().a);
                parts.add(currentPart.toLowerCase());
                return parts;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            private SQLQuerySymbolDefinition unrollSymbolDefinition(SQLQuerySymbolDefinition def) {
                while (def instanceof SQLQuerySymbolEntry) {
                    void entry;
                    SQLQuerySymbolEntry sQLQuerySymbolEntry = (SQLQuerySymbolEntry)def;
                    def = entry.getDefinition();
                }
                return def;
            }

            private List<SQLQueryCompletionItem> prepareLexicalItemCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLQueryLexicalScopeItem lexicalItem2, int position) {
                Interval pos = Interval.of((int)position, (int)position);
                if (lexicalItem2 instanceof SQLQueryQualifiedName) {
                    Interval catalogRange;
                    Interval schemaRange;
                    SQLQueryQualifiedName qname = (SQLQueryQualifiedName)lexicalItem2;
                    Interval nameRange = qname.entityName.getSyntaxNode().getRealInterval();
                    if (nameRange.properlyContains(pos)) {
                        String part = qname.entityName.getRawName().substring(0, position - nameRange.a);
                        if (qname.schemaName != null) {
                            SQLQuerySymbolDefinition scopeDef = this.unrollSymbolDefinition(qname.schemaName.getDefinition());
                            if (scopeDef instanceof SQLQuerySymbolByDbObjectDefinition) {
                                SQLQuerySymbolByDbObjectDefinition byObjDef = (SQLQuerySymbolByDbObjectDefinition)scopeDef;
                                return this.prepareObjectComponentCompletions(monitor, byObjDef.getDbObject(), part, DBSEntity.class);
                            }
                            return Collections.emptyList();
                        }
                        return this.prepareIdentifierCompletions(monitor, List.of(part), DBSEntity.class);
                    }
                    if (qname.schemaName != null && (schemaRange = qname.schemaName.getSyntaxNode().getRealInterval()).properlyContains(pos)) {
                        String part = qname.schemaName.getRawName().substring(0, position - schemaRange.a);
                        if (qname.catalogName != null) {
                            SQLQuerySymbolDefinition scopeDef = this.unrollSymbolDefinition(qname.schemaName.getDefinition());
                            if (scopeDef instanceof SQLQuerySymbolByDbObjectDefinition) {
                                SQLQuerySymbolByDbObjectDefinition byObjDef = (SQLQuerySymbolByDbObjectDefinition)scopeDef;
                                return this.prepareObjectComponentCompletions(monitor, byObjDef.getDbObject(), part, DBSSchema.class);
                            }
                            return Collections.emptyList();
                        }
                        return this.prepareObjectComponentCompletions(monitor, (DBSObject)dbcExecutionContext.getDataSource(), part, DBSSchema.class);
                    }
                    if (qname.catalogName != null && (catalogRange = qname.catalogName.getSyntaxNode().getRealInterval()).properlyContains(pos)) {
                        String part = qname.catalogName.getRawName().substring(0, position - catalogRange.a);
                        return this.prepareObjectComponentCompletions(monitor, (DBSObject)dbcExecutionContext.getDataSource(), part, DBSCatalog.class);
                    }
                    throw new UnsupportedOperationException("Illegal SQLQueryQualifiedName");
                }
                if (lexicalItem2 instanceof SQLQuerySymbolEntry) {
                    SQLQuerySymbolEntry entry = (SQLQuerySymbolEntry)lexicalItem2;
                    Interval nameRange = entry.getSyntaxNode().getRealInterval();
                    String part = entry.getRawName().substring(0, position - nameRange.a);
                    return this.prepareIdentifierCompletions(monitor, List.of(part), null);
                }
                throw new UnsupportedOperationException("Unexpected lexical item kind to complete " + lexicalItem2.getClass().getName());
            }

            private List<SQLQueryCompletionItem> prepareKeywordCompletions(Set<String> keywords, String filter) {
                Stream<Object> stream = keywords.stream();
                if (filter != null) {
                    stream = stream.filter(s -> s.toLowerCase().contains(filter));
                }
                return stream.map(SQLQueryCompletionItem::forReservedWord).toList();
            }

            @NotNull
            private List<SQLQueryCompletionItem> prepareColumnCompletions(@Nullable String filterOrNull) {
                List<SQLQueryCompletionItem> subsetColumns = context.getColumnsList().stream().filter(c -> filterOrNull == null || c.symbol.getName().toLowerCase().contains(filterOrNull)).map(rc -> SQLQueryCompletionItem.forSubsetColumn(rc, this.referencedSources.get(rc.source), true)).toList();
                LinkedList<SQLQueryCompletionItem> tableRefs = new LinkedList<SQLQueryCompletionItem>();
                for (SourceResolutionResult rr : this.referencedSources.values()) {
                    if (rr.aliasOrNull != null && !rr.isCteSubquery) {
                        if (filterOrNull != null && !rr.aliasOrNull.getName().toLowerCase().contains(filterOrNull)) continue;
                        tableRefs.add(SQLQueryCompletionItem.forSubqueryAlias(rr.aliasOrNull, rr.source));
                        continue;
                    }
                    if (rr.tableOrNull == null || filterOrNull != null && !rr.tableOrNull.getName().toLowerCase().contains(filterOrNull)) continue;
                    tableRefs.add(SQLQueryCompletionItem.forRealTable(rr.tableOrNull, true));
                }
                return Stream.of(subsetColumns, tableRefs).flatMap(Collection::stream).toList();
            }

            @NotNull
            private List<SQLQueryCompletionItem> prepareTableCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                HashSet<DBSObject> alreadyReferencedObjects = new HashSet<DBSObject>();
                LinkedList<SQLQueryCompletionItem> completions = new LinkedList<SQLQueryCompletionItem>();
                for (SourceResolutionResult rr : this.referencedSources.values()) {
                    if (rr.aliasOrNull != null && rr.isCteSubquery) {
                        completions.add(SQLQueryCompletionItem.forSubqueryAlias(rr.aliasOrNull, rr.source));
                    }
                    if (rr.tableOrNull == null) continue;
                    alreadyReferencedObjects.add((DBSObject)rr.tableOrNull);
                }
                if (dbcExecutionContext != null && dbcExecutionContext.getDataSource() != null) {
                    try {
                        DBPDataSource dBPDataSource;
                        DBCExecutionContextDefaults defaults = dbcExecutionContext.getContextDefaults();
                        if (defaults != null) {
                            DBPDataSource dBPDataSource2;
                            DBSSchema defaultSchema = defaults.getDefaultSchema();
                            DBSCatalog defaultCatalog = defaults.getDefaultCatalog();
                            if (defaultCatalog == null && defaultSchema == null && (dBPDataSource2 = dbcExecutionContext.getDataSource()) instanceof DBSObjectContainer) {
                                DBSObjectContainer container = (DBSObjectContainer)dBPDataSource2;
                                this.collectTables(monitor, container, alreadyReferencedObjects, completions);
                            } else if (request.getContext().isSearchGlobally() && defaultCatalog != null) {
                                this.collectTables(monitor, (DBSObjectContainer)defaultCatalog, alreadyReferencedObjects, completions);
                            } else if (defaultSchema != null) {
                                this.collectTables(monitor, (DBSObjectContainer)defaultSchema, alreadyReferencedObjects, completions);
                            }
                            if (defaultCatalog != null) {
                                this.collectSchemas(monitor, (DBSObjectContainer)defaultCatalog, completions);
                            }
                        }
                        if ((dBPDataSource = dbcExecutionContext.getDataSource()) instanceof DBSObjectContainer) {
                            DBSObjectContainer container = (DBSObjectContainer)dBPDataSource;
                            this.collectCatalogs(monitor, container, completions);
                        }
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                }
                return completions;
            }

            private void collectTables(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull Set<DBSObject> alreadyReferencedTables, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                this.collectObjectsRecursively(monitor, container, new HashSet<DBSObject>(), accumulator, List.of(DBSTable.class, DBSView.class), o -> SQLQueryCompletionItem.forRealTable(o, alreadyReferencedTables.contains(o)));
            }

            private void collectSchemas(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                this.collectObjectsRecursively(monitor, container, new HashSet<DBSObject>(), accumulator, List.of(DBSSchema.class), SQLQueryCompletionItem::forDbObject);
            }

            private void collectCatalogs(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                this.collectObjectsRecursively(monitor, container, new HashSet<DBSObject>(), accumulator, List.of(DBSCatalog.class), SQLQueryCompletionItem::forDbObject);
            }

            @NotNull
            private <T extends DBSObject> void collectObjectsRecursively(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull Set<DBSObject> alreadyReferencedObjects, @NotNull LinkedList<SQLQueryCompletionItem> accumulator, @NotNull List<Class<? extends T>> types, @NotNull Function<T, SQLQueryCompletionItem> completionItemFabric) throws DBException {
                Collection children = container.getChildren(monitor);
                for (DBSObject child : children) {
                    if (DBUtils.isHiddenObject((Object)child)) continue;
                    if (types.stream().anyMatch(t -> t.isInstance(child)) && !alreadyReferencedObjects.contains(child)) {
                        accumulator.add(completionItemFabric.apply(child));
                        continue;
                    }
                    if (!(child instanceof DBSObjectContainer)) continue;
                    DBSObjectContainer sc = (DBSObjectContainer)child;
                    if (!DBStructUtils.isConnectedContainer((DBPObject)child)) continue;
                    this.collectObjectsRecursively(monitor, sc, alreadyReferencedObjects, accumulator, types, completionItemFabric);
                }
            }
        };
    }
}

