/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryAliasedRowsContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryCombinedContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryPureResultTupleContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultTupleContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryTableRowsContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public abstract class SQLQueryDataContext {
    @NotNull
    public abstract List<SQLQueryResultColumn> getColumnsList();

    @Nullable
    public abstract DBSEntity findRealTable(@NotNull DBRProgressMonitor var1, @NotNull List<String> var2);

    @Nullable
    public abstract SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor var1, @NotNull String var2);

    @Nullable
    public SourceResolutionResult resolveSource(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        DBSEntity table = this.findRealTable(monitor, tableName);
        SQLQueryRowsSourceModel source = table == null ? null : this.findRealSource(table);
        return source == null ? null : SourceResolutionResult.forRealTableByName(source, table);
    }

    @Nullable
    public abstract SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity var1);

    @NotNull
    public final SQLQueryDataContext overrideResultTuple(@NotNull List<SQLQueryResultColumn> columns) {
        return new SQLQueryResultTupleContext(this, columns);
    }

    @NotNull
    public final SQLQueryDataContext combine(@NotNull SQLQueryDataContext other) {
        return new SQLQueryCombinedContext(this, other);
    }

    @NotNull
    public final SQLQueryDataContext extendWithRealTable(@NotNull DBSEntity table, @NotNull SQLQueryRowsSourceModel source) {
        return new SQLQueryTableRowsContext(this, table, source);
    }

    @NotNull
    public final SQLQueryDataContext extendWithTableAlias(@NotNull SQLQuerySymbol alias, @NotNull SQLQueryRowsSourceModel source) {
        return new SQLQueryAliasedRowsContext(this, alias, source);
    }

    @NotNull
    public final SQLQueryDataContext hideSources() {
        return new SQLQueryPureResultTupleContext(this);
    }

    @NotNull
    public abstract SQLDialect getDialect();

    @NotNull
    public abstract SQLQueryRowsSourceModel getDefaultTable(@NotNull STMTreeNode var1);

    public DBSObject findRealObject(DBRProgressMonitor monitor, DBSObjectType objectType, List<String> name) {
        return null;
    }

    public KnownSourcesInfo collectKnownSources() {
        KnownSourcesInfo result = new KnownSourcesInfo();
        this.collectKnownSourcesImpl(result);
        return result;
    }

    protected abstract void collectKnownSourcesImpl(@NotNull KnownSourcesInfo var1);

    public static class KnownSourcesInfo {
        @NotNull
        private final Map<SQLQueryRowsSourceModel, SourceResolutionResult> sources = new HashMap<SQLQueryRowsSourceModel, SourceResolutionResult>();

        public void registerTableReference(@NotNull SQLQueryRowsSourceModel source, @NotNull DBSEntity table) {
            SQLQueryRowsCorrelatedSourceModel cc;
            SQLQueryRowsSourceModel sourceModel = source instanceof SQLQueryRowsCorrelatedSourceModel && (cc = (SQLQueryRowsCorrelatedSourceModel)source).getCorrelationColumNames().isEmpty() ? cc.getSource() : source;
            this.sources.compute(sourceModel, (k, v) -> v == null ? SourceResolutionResult.forRealTableByName(sourceModel, table) : SourceResolutionResult.withRealTable(v, table));
        }

        public void registerAlias(@NotNull SQLQueryRowsSourceModel source, @NotNull SQLQuerySymbol alias) {
            SQLQueryRowsCorrelatedSourceModel cc;
            SQLQueryRowsSourceModel sourceModel = source instanceof SQLQueryRowsCorrelatedSourceModel && (cc = (SQLQueryRowsCorrelatedSourceModel)source).getCorrelationColumNames().isEmpty() ? cc.getSource() : source;
            this.sources.compute(sourceModel, (k, v) -> v == null ? SourceResolutionResult.forSourceByAlias(sourceModel, alias) : SourceResolutionResult.withAlias(v, alias));
        }

        @NotNull
        public Map<SQLQueryRowsSourceModel, SourceResolutionResult> getResolutionResults() {
            return Collections.unmodifiableMap(this.sources);
        }
    }
}

