/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnConstraintKind;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;

public class SQLQueryColumnConstraintSpec
extends SQLQueryNodeModel {
    @Nullable
    private final SQLQueryQualifiedName constraintName;
    @NotNull
    private final SQLQueryColumnConstraintKind kind;
    @Nullable
    private final SQLQueryRowsTableDataModel referencedTable;
    @Nullable
    private final List<SQLQuerySymbolEntry> referencedColumns;
    @Nullable
    private final SQLQueryValueExpression checkExpression;

    public SQLQueryColumnConstraintSpec(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryQualifiedName constraintName, @NotNull SQLQueryColumnConstraintKind kind, @Nullable SQLQueryRowsTableDataModel referencedTable, @Nullable List<SQLQuerySymbolEntry> referencedColumns, @Nullable SQLQueryValueExpression checkExpression) {
        super(syntaxNode.getRealInterval(), syntaxNode, checkExpression);
        this.constraintName = constraintName;
        this.kind = kind;
        this.referencedTable = referencedTable;
        this.referencedColumns = referencedColumns;
        this.checkExpression = checkExpression;
    }

    @NotNull
    public SQLQueryQualifiedName getConstraintName() {
        return this.constraintName;
    }

    @NotNull
    public SQLQueryColumnConstraintKind getKind() {
        return this.kind;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitColumnConstraintSpec(this, arg);
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return null;
    }

    public void propagateContext(@NotNull SQLQueryDataContext dataContext, @Nullable SQLQueryDataContext tableContext, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext referencedContext;
        if (this.referencedTable != null && (referencedContext = SQLQueryColumnConstraintSpec.propagateForReferencedEntity(this.referencedTable, this.referencedColumns, dataContext, statistics)) != null && referencedContext.getColumnsList().size() != 1) {
            statistics.appendWarning(this.getSyntaxNode(), "Inconsistent foreign key tuple size");
        }
        if (this.checkExpression != null && tableContext != null) {
            this.checkExpression.propagateContext(tableContext, statistics);
        }
    }

    @Nullable
    public static SQLQueryDataContext propagateForReferencedEntity(@NotNull SQLQueryRowsTableDataModel referencedTable, @Nullable List<SQLQuerySymbolEntry> referencedColumns, @NotNull SQLQueryDataContext dataContext, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext resultContext;
        block16: {
            statistics.setTreatErrorAsWarnings(true);
            SQLQueryDataContext referencedContext = referencedTable.propagateContext(dataContext, statistics);
            statistics.setTreatErrorAsWarnings(false);
            DBSEntity realTable = referencedTable.getTable();
            if (referencedColumns != null && !referencedColumns.isEmpty()) {
                ArrayList<SQLQueryResultColumn> resultColumns = new ArrayList<SQLQueryResultColumn>(referencedColumns.size());
                if (realTable != null) {
                    for (SQLQuerySymbolEntry columnRef : referencedColumns) {
                        SQLQueryResultColumn rc = referencedContext.resolveColumn(statistics.getMonitor(), columnRef.getName());
                        if (rc != null) {
                            if (columnRef.isNotClassified()) {
                                SQLQueryValueColumnReferenceExpression.propagateColumnDefinition(columnRef, rc, statistics);
                            }
                            resultColumns.add(rc.withNewIndex(resultColumns.size()));
                            continue;
                        }
                        statistics.appendWarning(columnRef, "Failed to resolve column " + columnRef.getName());
                        columnRef.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
                        resultColumns.add(new SQLQueryResultColumn(resultColumns.size(), columnRef.getSymbol(), referencedTable, realTable, null, SQLQueryExprType.UNKNOWN));
                    }
                } else {
                    statistics.appendWarning(referencedTable.getName().entityName, "Failed to validate " + (referencedColumns.size() > 1 ? "compound " : "") + "foreign key columns of table " + referencedTable.getName().toIdentifierString());
                    for (SQLQuerySymbolEntry columnRef : referencedColumns) {
                        if (columnRef.isNotClassified()) {
                            columnRef.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
                        }
                        resultColumns.add(new SQLQueryResultColumn(resultColumns.size(), columnRef.getSymbol(), referencedTable, referencedTable.getTable(), null, SQLQueryExprType.UNKNOWN));
                    }
                }
                resultContext = referencedContext.overrideResultTuple(resultColumns);
            } else if (realTable != null) {
                try {
                    DBSEntityConstraint dBSEntityConstraint;
                    Optional<DBSEntityConstraint> pk = ((Collection)Optional.ofNullable(realTable.getConstraints(statistics.getMonitor())).orElse(Collections.emptyList())).stream().filter(c -> c.getConstraintType().equals(DBSEntityConstraintType.PRIMARY_KEY)).findFirst();
                    if (pk.isPresent() && (dBSEntityConstraint = pk.get()) instanceof DBSEntityReferrer) {
                        DBSEntityReferrer referrer = (DBSEntityReferrer)dBSEntityConstraint;
                        List pkAttrs = Optional.ofNullable(referrer.getAttributeReferences(statistics.getMonitor())).orElse(Collections.emptyList()).stream().map(DBSEntityAttributeRef::getAttribute).collect(Collectors.toList());
                        if (pkAttrs.isEmpty()) {
                            statistics.appendWarning(referencedTable.getName().entityName, "Failed to obtain primary key attribute of the referenced table " + referencedTable.getName().toIdentifierString());
                            resultContext = null;
                        } else {
                            List<SQLQueryResultColumn> resultColumns = SQLQueryRowsTableDataModel.prepareResultColumnsList(referencedTable.getName().entityName, referencedTable, realTable, referencedContext, statistics, pkAttrs);
                            resultContext = referencedContext.overrideResultTuple(resultColumns);
                        }
                        break block16;
                    }
                    statistics.appendWarning(referencedTable.getName().entityName, "Failed to obtain primary key of the referenced table " + referencedTable.getName().toIdentifierString());
                    resultContext = null;
                }
                catch (DBException e) {
                    statistics.appendError(referencedTable.getName().entityName, "Failed to resolve primary key of the referenced table " + referencedTable.getName().toIdentifierString(), e);
                    resultContext = null;
                }
            } else {
                resultContext = null;
            }
        }
        return resultContext;
    }
}

