/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLQueryTableCreateModel
extends SQLQueryModelContent {
    @NotNull
    private final SQLQueryQualifiedName tableName;
    @NotNull
    private final List<SQLQueryColumnSpec> columns;
    @NotNull
    private final List<SQLQueryTableConstraintSpec> constraints;
    @Nullable
    private SQLQueryDataContext dataContext = null;

    public SQLQueryTableCreateModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryQualifiedName tableName, @NotNull List<SQLQueryColumnSpec> columns, @NotNull List<SQLQueryTableConstraintSpec> constraints) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.tableName = tableName;
        this.columns = List.copyOf(columns);
        this.constraints = List.copyOf(constraints);
        this.columns.forEach(sQLQueryNodeModel -> super.registerSubnode((SQLQueryNodeModel)sQLQueryNodeModel));
        this.constraints.forEach(sQLQueryNodeModel -> super.registerSubnode((SQLQueryNodeModel)sQLQueryNodeModel));
    }

    @NotNull
    public SQLQueryQualifiedName getTableName() {
        return this.tableName;
    }

    @NotNull
    public List<SQLQueryColumnSpec> getColumns() {
        return this.columns;
    }

    @NotNull
    public List<SQLQueryTableConstraintSpec> getConstraints() {
        return this.constraints;
    }

    @Override
    protected void applyContext(@NotNull SQLQueryDataContext dataContext, @NotNull SQLQueryRecognitionContext statistics) {
        this.dataContext = dataContext;
        if (this.tableName.isNotClassified()) {
            List<String> nameStrings = this.tableName.toListOfStrings();
            DBSEntity realTable = dataContext.findRealTable(statistics.getMonitor(), nameStrings);
            if (realTable != null) {
                this.tableName.setDefinition((DBSObject)realTable);
            } else {
                this.tableName.setSymbolClass(SQLQuerySymbolClass.TABLE);
            }
            SQLQueryRowsTableValueModel virtualTableRows = new SQLQueryRowsTableValueModel(this.getSyntaxNode(), Collections.emptyList());
            ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(this.columns.size());
            for (SQLQueryColumnSpec columnSpec : this.columns) {
                SQLQuerySymbol columnName;
                SQLQuerySymbolEntry columnNameEntry = columnSpec.getColumnName();
                if (columnNameEntry != null) {
                    columnName = columnNameEntry.getSymbol();
                    if (columnNameEntry.isNotClassified()) {
                        columnName.setDefinition(columnNameEntry);
                        columnName.setSymbolClass(SQLQuerySymbolClass.COLUMN);
                    }
                } else {
                    columnName = new SQLQuerySymbol("?");
                }
                columns.add(new SQLQueryResultColumn(columns.size(), columnName, virtualTableRows, null, null, columnSpec.getDeclaredColumnType()));
            }
            SQLQueryDataContext tableContext = dataContext.overrideResultTuple(columns);
            for (SQLQueryColumnSpec columnSpec : this.columns) {
                columnSpec.propagateContext(dataContext, tableContext, statistics);
            }
            for (SQLQueryTableConstraintSpec constraintSpec : this.constraints) {
                constraintSpec.propagateContext(dataContext, tableContext, statistics);
            }
        }
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitCreateTable(this, arg);
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return this.dataContext;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return this.dataContext;
    }

    public static SQLQueryTableCreateModel recognize(SQLQueryModelRecognizer recognizer, STMTreeNode node) {
        SQLQueryQualifiedName tableName = recognizer.collectTableName(node);
        LinkedList<SQLQueryColumnSpec> columns = new LinkedList<SQLQueryColumnSpec>();
        LinkedList<SQLQueryTableConstraintSpec> constraints = new LinkedList<SQLQueryTableConstraintSpec>();
        STMTreeNode elementsNode = node.findChildOfName(STMKnownRuleNames.tableElementList);
        if (elementsNode != null) {
            int i = 1;
            while (i < elementsNode.getChildCount()) {
                STMTreeNode elementNode = elementsNode.getStmChild(i);
                if (elementNode.getChildCount() > 0) {
                    STMTreeNode payloadNode = elementNode.getStmChild(0);
                    switch (payloadNode.getNodeKindId()) {
                        case 33: {
                            columns.addLast(SQLQueryColumnSpec.recognize(recognizer, payloadNode));
                            break;
                        }
                        case 194: {
                            constraints.addLast(SQLQueryTableConstraintSpec.recognize(recognizer, payloadNode));
                        }
                    }
                }
                i += 2;
            }
        }
        return new SQLQueryTableCreateModel(node, tableName, columns, constraints);
    }
}

