/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class SQLQueryRowsTableDataModel
extends SQLQueryRowsSourceModel
implements SQLQuerySymbolDefinition {
    private static final Log log = Log.getLog(SQLQueryRowsTableDataModel.class);
    @NotNull
    private final SQLQueryQualifiedName name;
    @Nullable
    private DBSEntity table = null;

    public SQLQueryRowsTableDataModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryQualifiedName name) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.name = name;
    }

    @NotNull
    public SQLQueryQualifiedName getName() {
        return this.name;
    }

    @Nullable
    public DBSEntity getTable() {
        return this.table;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.table != null ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
    }

    @NotNull
    private static SQLQuerySymbol prepareColumnSymbol(@NotNull SQLQueryDataContext context, @NotNull DBSEntityAttribute attr) {
        String name = SQLUtils.identifierToCanonicalForm((SQLDialect)context.getDialect(), (String)attr.getName(), (boolean)false, (boolean)true);
        SQLQuerySymbol symbol = new SQLQuerySymbol(name);
        symbol.setDefinition(new SQLQuerySymbolByDbObjectDefinition((DBSObject)attr, SQLQuerySymbolClass.COLUMN));
        return symbol;
    }

    @NotNull
    protected List<SQLQueryResultColumn> prepareResultColumnsList(@NotNull SQLQuerySymbolEntry cause, @NotNull SQLQueryDataContext attrsContext, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        return SQLQueryRowsTableDataModel.prepareResultColumnsList(cause, this, this.table, attrsContext, statistics, attributes);
    }

    @NotNull
    public static List<SQLQueryResultColumn> prepareResultColumnsList(@NotNull SQLQuerySymbolEntry cause, @NotNull SQLQueryRowsSourceModel rowsSourceModel, @Nullable DBSEntity table, @NotNull SQLQueryDataContext attrsContext, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(attributes.size());
        for (DBSEntityAttribute dBSEntityAttribute : attributes) {
            if (DBUtils.isHiddenObject((Object)dBSEntityAttribute)) continue;
            columns.add(new SQLQueryResultColumn(columns.size(), SQLQueryRowsTableDataModel.prepareColumnSymbol(attrsContext, dBSEntityAttribute), rowsSourceModel, table, dBSEntityAttribute, SQLQueryRowsTableDataModel.obtainColumnType(cause, statistics, (DBSAttributeBase)dBSEntityAttribute)));
        }
        return columns;
    }

    @NotNull
    private static SQLQueryExprType obtainColumnType(@NotNull SQLQuerySymbolEntry reason, @NotNull SQLQueryRecognitionContext statistics, @NotNull DBSAttributeBase attr) {
        SQLQueryExprType type;
        try {
            type = SQLQueryExprType.forTypedObject(statistics.getMonitor(), (DBSTypedObject)attr, SQLQuerySymbolClass.COLUMN);
        }
        catch (DBException e) {
            log.debug((Object)e);
            statistics.appendError(reason, "Failed to resolve column type for column " + attr.getName(), e);
            type = SQLQueryExprType.UNKNOWN;
        }
        return type;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.name.isNotClassified()) {
            List<String> nameStrings = this.name.toListOfStrings();
            this.table = context.findRealTable(statistics.getMonitor(), nameStrings);
            if (this.table != null) {
                this.name.setDefinition((DBSObject)this.table);
                context = context.extendWithRealTable(this.table, this);
                try {
                    List attributes = this.table.getAttributes(statistics.getMonitor());
                    if (attributes != null) {
                        List<SQLQueryResultColumn> columns = this.prepareResultColumnsList(this.name.entityName, context, statistics, attributes);
                        context = context.overrideResultTuple(columns);
                    }
                }
                catch (DBException ex) {
                    statistics.appendError(this.name.entityName, "Failed to resolve columns of the table " + this.name.toIdentifierString(), ex);
                }
            } else {
                SourceResolutionResult rr = context.resolveSource(statistics.getMonitor(), nameStrings);
                if (rr != null && rr.tableOrNull == null && rr.source != null && rr.aliasOrNull != null && nameStrings.size() == 1) {
                    this.name.entityName.setDefinition(rr.aliasOrNull.getDefinition());
                    context = context.overrideResultTuple(rr.source.getResultDataContext().getColumnsList());
                } else {
                    SQLQuerySymbolClass tableSymbolClass = statistics.isTreatErrorsAsWarnings() ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
                    this.name.setSymbolClass(tableSymbolClass);
                    statistics.appendError(this.name.entityName, "Table " + this.name.toIdentifierString() + " not found");
                }
            }
        }
        return context;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsTableData(this, arg);
    }
}

