/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridServer
implements DBSObject {
    private String linkName;
    private String host;
    private String port;
    private String dbName;
    private String userName;
    private String properties;
    private String owner;
    private String description;
    private CubridDataSource container;

    public CubridServer(@NotNull CubridDataSource container, @NotNull JDBCResultSet dbResult) {
        this.container = container;
        this.linkName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"link_name");
        this.host = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"host");
        this.port = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"port");
        this.dbName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"db_name");
        this.userName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"user_name");
        this.properties = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"properties");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"owner");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.linkName;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getHost() {
        return this.host;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getPort() {
        return this.port;
    }

    @Property(viewable=true, order=4)
    @NotNull
    public String getDbName() {
        return this.dbName;
    }

    @Property(viewable=true, order=5)
    @NotNull
    public String getUserName() {
        return this.userName;
    }

    @Property(viewable=true, order=6)
    @Nullable
    public String getProperties() {
        return this.properties;
    }

    @Property(viewable=true, order=7)
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=8)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public boolean isPersisted() {
        return true;
    }

    public DBSObject getParentObject() {
        return this.container;
    }

    public DBPDataSource getDataSource() {
        return this.container;
    }
}

