/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLEditor
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageSQLEditor.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqleditor";
    private static final String TEXT_EDITOR_PAGE_ID = "org.eclipse.ui.preferencePages.GeneralTextEditor";
    private Combo editorSeparateConnectionCombo;
    private Button connectOnActivationCheck;
    private Button connectOnExecuteCheck;
    private Button autoSaveOnChange;
    private Button saveOnQueryExecution;
    private Button autoSaveOnClose;
    private Button autoSaveActiveSchema;
    private Button closeTabOnErrorCheck;
    private Combo resultsOrientationCombo;
    private Button autoOpenOutputView;
    private Button replaceCurrentTab;
    private Spinner sizeWarningThresholdSpinner;
    private static final List<ModelPreferences.SeparateConnectionBehavior> editorUseSeparateConnectionValues = List.of(ModelPreferences.SeparateConnectionBehavior.ALWAYS, ModelPreferences.SeparateConnectionBehavior.DEFAULT, ModelPreferences.SeparateConnectionBehavior.NEVER);

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("database.editor.separate.connection") || store.contains("database.editor.connect.on.activate") || store.contains("database.editor.connect.on.execute") || store.contains("SQLEditor.autoSaveOnClose") || store.contains("SQLEditor.autoSaveOnExecute") || store.contains("SQLEditor.autoSaveActiveSchema") || store.contains("SQLEditor.resultSet.closeOnError");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group connectionsGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_connections, (int)1, (int)2, (int)0);
        ((GridData)connectionsGroup.getLayoutData()).horizontalSpan = 2;
        this.editorSeparateConnectionCombo = UIUtils.createLabelCombo((Composite)UIUtils.createComposite((Composite)connectionsGroup, (int)3), (String)SQLEditorMessages.pref_page_sql_editor_label_separate_connection_each_editor, (int)12);
        this.editorSeparateConnectionCombo.setToolTipText(NLS.bind((String)SQLEditorMessages.pref_page_sql_editor_label_separate_connection_each_editor_tip, (Object)PrefUtils.collectSingleConnectionDrivers()));
        ((GridData)this.editorSeparateConnectionCombo.getLayoutData()).grabExcessHorizontalSpace = false;
        this.editorSeparateConnectionCombo.setItems((String[])editorUseSeparateConnectionValues.stream().map(ModelPreferences.SeparateConnectionBehavior::getTitle).toArray(String[]::new));
        this.connectOnActivationCheck = UIUtils.createCheckbox((Composite)connectionsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_connect_on_editor_activation, (boolean)false);
        this.connectOnExecuteCheck = UIUtils.createCheckbox((Composite)connectionsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_connect_on_query_execute, (boolean)false);
        Group autoSaveGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_auto_save, (int)1, (int)2, (int)0);
        this.autoSaveOnChange = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_save_on_change, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_save_on_change_tip, (boolean)false, (int)1);
        this.autoSaveOnClose = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_save_on_close, (boolean)false);
        this.saveOnQueryExecution = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_save_on_query_execute, (String)SQLEditorMessages.pref_page_sql_editor_label_save_on_query_execute, (boolean)false, (int)1);
        this.autoSaveActiveSchema = UIUtils.createCheckbox((Composite)autoSaveGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_save_active_schema, (boolean)false);
        Group layoutGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_result_view, (int)1, (int)32, (int)0);
        ((GridData)layoutGroup.getLayoutData()).horizontalSpan = 2;
        this.closeTabOnErrorCheck = UIUtils.createCheckbox((Composite)layoutGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_close_results_tab_on_error, (String)SQLEditorMessages.pref_page_sql_editor_label_close_results_tab_on_error_tip, (boolean)false, (int)1);
        this.replaceCurrentTab = UIUtils.createCheckbox((Composite)layoutGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_replace_on_single_query_exec_view, (String)SQLEditorMessages.pref_page_sql_editor_label_replace_on_single_query_exec_view_tip, (boolean)true, (int)2);
        Composite orientationComposite = UIUtils.createComposite((Composite)layoutGroup, (int)2);
        this.resultsOrientationCombo = UIUtils.createLabelCombo((Composite)orientationComposite, (String)SQLEditorMessages.pref_page_sql_editor_label_results_orientation, (String)SQLEditorMessages.pref_page_sql_editor_label_results_orientation_tip, (int)12);
        this.resultsOrientationCombo.setLayoutData((Object)new GridData(32));
        SQLEditor.ResultSetOrientation[] resultSetOrientationArray = SQLEditor.ResultSetOrientation.values();
        int n = resultSetOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLEditor.ResultSetOrientation orientation = resultSetOrientationArray[n2];
            if (orientation.isSupported()) {
                this.resultsOrientationCombo.add(orientation.getLabel());
            }
            ++n2;
        }
        this.autoOpenOutputView = UIUtils.createCheckbox((Composite)layoutGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_open_output_view, (String)SQLEditorMessages.pref_page_sql_editor_label_auto_open_output_view_tip, (boolean)false, (int)2);
        Composite rsSizeComposite = UIUtils.createComposite((Composite)layoutGroup, (int)2);
        this.sizeWarningThresholdSpinner = UIUtils.createLabelSpinner((Composite)rsSizeComposite, (String)SQLEditorMessages.pref_page_sql_editor_label_size_warning_threshold, (String)SQLEditorMessages.pref_page_sql_editor_label_size_warning_threshold_tip, (int)20, (int)2, (int)200);
        this.sizeWarningThresholdSpinner.setLayoutData((Object)new GridData(32));
        Group linksGroup = UIUtils.createControlGroup((Composite)composite, (String)"", (int)1, (int)32, (int)0);
        UIUtils.createPreferenceLink((Composite)linksGroup, (String)("<a>''{0}''</a> " + SQLEditorMessages.pref_page_sql_editor_link_text_editor), (String)TEXT_EDITOR_PAGE_ID, (IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), null);
        UIUtils.createPreferenceLink((Composite)linksGroup, (String)SQLEditorMessages.pref_page_sql_editor_link_colors_and_fonts, (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", (IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), null);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.loadPreferences(this.getTargetPreferenceStore(), false);
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("database.editor.separate.connection", editorUseSeparateConnectionValues.get(this.editorSeparateConnectionCombo.getSelectionIndex()).name());
            store.setValue("database.editor.connect.on.activate", this.connectOnActivationCheck.getSelection());
            store.setValue("database.editor.connect.on.execute", this.connectOnExecuteCheck.getSelection());
            store.setValue("SQLEditor.autoSaveOnChange", this.autoSaveOnChange.getSelection());
            store.setValue("SQLEditor.autoSaveOnClose", this.autoSaveOnClose.getSelection());
            store.setValue("SQLEditor.autoSaveOnExecute", this.saveOnQueryExecution.getSelection());
            store.setValue("SQLEditor.autoSaveActiveSchema", this.autoSaveActiveSchema.getSelection());
            store.setValue("SQLEditor.resultSet.closeOnError", this.closeTabOnErrorCheck.getSelection());
            store.setValue("SQLEditor.resultSet.replaceCurrentTab", this.replaceCurrentTab.getSelection());
            String orientationLabel = this.resultsOrientationCombo.getText();
            SQLEditor.ResultSetOrientation[] resultSetOrientationArray = SQLEditor.ResultSetOrientation.values();
            int n = resultSetOrientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SQLEditor.ResultSetOrientation orientation = resultSetOrientationArray[n2];
                if (orientationLabel.equals(orientation.getLabel())) {
                    DBWorkbench.getPlatform().getPreferenceStore().setValue("SQLEditor.resultSet.orientation", orientation.name());
                    break;
                }
                ++n2;
            }
            store.setValue("SQLEditor.outputPanel.autoShow", this.autoOpenOutputView.getSelection());
            store.setValue("SQLEditor.resultSet.queryTabLimit", this.sizeWarningThresholdSpinner.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("database.editor.separate.connection");
        store.setToDefault("database.editor.connect.on.activate");
        store.setToDefault("database.editor.connect.on.execute");
        store.setToDefault("SQLEditor.resultSet.queryTabLimit");
        store.setToDefault("SQLEditor.autoSaveOnChange");
        store.setToDefault("SQLEditor.autoSaveOnClose");
        store.setToDefault("SQLEditor.autoSaveOnExecute");
        store.setToDefault("SQLEditor.autoSaveActiveSchema");
        store.setToDefault("SQLEditor.resultSet.closeOnError");
        store.setToDefault("SQLEditor.resultSet.replaceCurrentTab");
        store.setToDefault("SQLEditor.resultSet.orientation");
        store.setToDefault("SQLEditor.outputPanel.autoShow");
    }

    protected void performDefaults() {
        this.loadPreferences(this.getTargetPreferenceStore(), true);
        super.performDefaults();
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    private void loadPreferences(DBPPreferenceStore store, boolean useDefaults) {
        try {
            UIUtils.setComboSelection((Combo)this.editorSeparateConnectionCombo, (String)ModelPreferences.SeparateConnectionBehavior.parse((String)(useDefaults ? store.getDefaultString("database.editor.separate.connection") : store.getString("database.editor.separate.connection"))).getTitle());
            this.connectOnActivationCheck.setSelection(useDefaults ? store.getDefaultBoolean("database.editor.connect.on.activate") : store.getBoolean("database.editor.connect.on.activate"));
            this.connectOnExecuteCheck.setSelection(useDefaults ? store.getDefaultBoolean("database.editor.connect.on.execute") : store.getBoolean("database.editor.connect.on.execute"));
            this.autoSaveOnChange.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.autoSaveOnChange") : store.getBoolean("SQLEditor.autoSaveOnChange"));
            this.autoSaveOnClose.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.autoSaveOnClose") : store.getBoolean("SQLEditor.autoSaveOnClose"));
            this.saveOnQueryExecution.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.autoSaveOnExecute") : store.getBoolean("SQLEditor.autoSaveOnExecute"));
            this.autoSaveActiveSchema.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.autoSaveActiveSchema") : store.getBoolean("SQLEditor.autoSaveActiveSchema"));
            this.closeTabOnErrorCheck.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.resultSet.closeOnError") : store.getBoolean("SQLEditor.resultSet.closeOnError"));
            this.replaceCurrentTab.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.resultSet.replaceCurrentTab") : store.getBoolean("SQLEditor.resultSet.replaceCurrentTab"));
            UIUtils.setComboSelection((Combo)this.resultsOrientationCombo, (String)SQLEditor.ResultSetOrientation.valueOf(useDefaults ? store.getDefaultString("SQLEditor.resultSet.orientation") : store.getString("SQLEditor.resultSet.orientation")).getLabel());
            this.autoOpenOutputView.setSelection(useDefaults ? store.getDefaultBoolean("SQLEditor.outputPanel.autoShow") : store.getBoolean("SQLEditor.outputPanel.autoShow"));
            this.sizeWarningThresholdSpinner.setSelection(useDefaults ? store.getDefaultInt("SQLEditor.resultSet.queryTabLimit") : store.getInt("SQLEditor.resultSet.queryTabLimit"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }
}

