/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionProposalBase;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionSet;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDummyDataSourceContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryCompletionDescriptionProvider;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryCompletionExtraTextProvider;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryCompletionTextProvider;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProposal;

public class SQLQueryCompletionAnalyzer
implements DBRRunnableParametrized<DBRProgressMonitor> {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    private final StyledString.Styler extraTextStyler = StyledString.createColorRegistryStyler((String)"DECORATIONS_COLOR", null);
    @NotNull
    private final SQLEditorBase editor;
    @NotNull
    private final SQLCompletionRequest request;
    @NotNull
    private volatile List<SQLCompletionProposal> proposals = Collections.emptyList();

    public SQLQueryCompletionAnalyzer(@NotNull SQLEditorBase editor, @NotNull SQLCompletionRequest request) {
        this.editor = editor;
        this.request = request;
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int position = this.request.getDocumentOffset();
        SQLQueryCompletionContext completionContext = this.editor.obtainCompletionContext(position);
        if (completionContext != null && this.request.getContext().getDataSource() != null) {
            SQLQueryCompletionSet completionSet = completionContext.prepareProposal(monitor, position, this.request);
            SQLQueryCompletionTextProvider formatter = new SQLQueryCompletionTextProvider(this.request, completionContext, monitor);
            SQLQueryCompletionExtraTextProvider extraFormatter = new SQLQueryCompletionExtraTextProvider();
            SQLQueryCompletionDescriptionProvider descriptionProvider = new SQLQueryCompletionDescriptionProvider();
            this.proposals = new ArrayList<SQLCompletionProposal>(completionSet.getItems().size());
            for (SQLQueryCompletionItem item : completionSet.getItems()) {
                DBSObject object = SQLQueryDummyDataSourceContext.isDummyObject((Object)item.getObject()) ? null : item.getObject();
                DBIcon image = switch (item.getKind()) {
                    case SQLQueryCompletionItemKind.UNKNOWN -> DBValueFormatting.getObjectImage((DBPObject)item.getObject());
                    case SQLQueryCompletionItemKind.RESERVED -> UIIcon.SQL_TEXT;
                    case SQLQueryCompletionItemKind.SUBQUERY_ALIAS -> DBIcon.TREE_TABLE_ALIAS;
                    case SQLQueryCompletionItemKind.DERIVED_COLUMN_NAME -> DBIcon.TREE_FOREIGN_KEY_COLUMN;
                    case SQLQueryCompletionItemKind.NEW_TABLE_NAME -> DBIcon.TREE_TABLE;
                    case SQLQueryCompletionItemKind.USED_TABLE_NAME -> UIIcon.EDIT_TABLE;
                    case SQLQueryCompletionItemKind.TABLE_COLUMN_NAME -> DBIcon.TREE_COLUMN;
                    default -> throw new IllegalStateException("Unexpected completion item kind " + String.valueOf(item.getKind()));
                };
                DBPKeywordType kwType = item.getKind() == SQLQueryCompletionItemKind.RESERVED ? DBPKeywordType.KEYWORD : DBPKeywordType.OTHER;
                String text = (String)item.apply((SQLQueryCompletionItemVisitor)formatter);
                String description = (String)item.apply((SQLQueryCompletionItemVisitor)descriptionProvider);
                this.proposals.add(new SQLCompletionProposal(this.request, text, text, text.length(), (DBPImage)image, kwType, description, (DBPNamedObject)object, Collections.emptyMap(), (DBPNamedObject)object, item, extraFormatter){
                    private final /* synthetic */ DBPNamedObject val$object;
                    private final /* synthetic */ SQLQueryCompletionItem val$item;
                    private final /* synthetic */ SQLQueryCompletionExtraTextProvider val$extraFormatter;
                    {
                        this.val$object = dBPNamedObject;
                        this.val$item = sQLQueryCompletionItem;
                        this.val$extraFormatter = sQLQueryCompletionExtraTextProvider;
                        super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6, $anonymous7, $anonymous8);
                    }

                    public Object getAdditionalInfo(DBRProgressMonitor monitor) {
                        if (this.val$object instanceof DBSObject) {
                            DBSObject o = (DBSObject)this.val$object;
                            DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(monitor, o, true);
                        }
                        return super.getAdditionalInfo(monitor);
                    }

                    @Override
                    public StyledString getStyledDisplayString() {
                        StyledString result = super.getStyledDisplayString();
                        String extra = (String)this.val$item.apply((SQLQueryCompletionItemVisitor)this.val$extraFormatter);
                        if (extra != null) {
                            int oldLength = result.length();
                            result.append(" " + extra);
                            result.setStyle(oldLength, result.length() - oldLength, SQLQueryCompletionAnalyzer.this.extraTextStyler);
                        }
                        return result;
                    }
                });
            }
            if (this.request.getContext().isSortAlphabetically()) {
                this.proposals.sort(Comparator.comparing(SQLCompletionProposalBase::getReplacementString, String::compareToIgnoreCase));
            }
        }
    }

    @NotNull
    public List<? extends ICompletionProposal> getProposals() {
        return this.proposals;
    }
}

