/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLTableAliasInsertMode;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class SQLQueryCompletionTextProvider
implements SQLQueryCompletionItemVisitor<String> {
    private final SQLCompletionRequest request;
    private final SQLQueryCompletionContext queryCompletionContext;
    private final SQLTableAliasInsertMode aliasMode;
    private final char structSeparator;
    private final Set<String> localKnownColumnNames;
    private final DBRProgressMonitor monitor;

    public SQLQueryCompletionTextProvider(@NotNull SQLCompletionRequest request, @NotNull SQLQueryCompletionContext queryCompletionContext, @NotNull DBRProgressMonitor monitor) {
        this.request = request;
        this.queryCompletionContext = queryCompletionContext;
        this.aliasMode = SQLTableAliasInsertMode.fromPreferences((DBPPreferenceStore)request.getContext().getSyntaxManager().getPreferenceStore());
        this.structSeparator = request.getContext().getDataSource().getSQLDialect().getStructSeparator();
        this.localKnownColumnNames = queryCompletionContext.getDataContext() == null ? Collections.emptySet() : queryCompletionContext.getDataContext().getColumnsList().stream().map(c -> c.symbol.getName()).collect(Collectors.toSet());
        this.monitor = monitor;
    }

    @NotNull
    public String visitSubqueryAlias(@NotNull SQLQueryCompletionItem.SQLSubqueryAliasCompletionItem subqueryAlias) {
        return subqueryAlias.symbol.getName();
    }

    @NotNull
    public String visitColumnName(@NotNull SQLQueryCompletionItem.SQLColumnNameCompletionItem columnName) {
        Object suffix;
        String preparedColumnName = this.convertCaseIfNeeded(columnName.columnInfo.symbol.getName());
        if (this.queryCompletionContext.getInspectionResult().expectingColumnIntroduction && this.aliasMode != SQLTableAliasInsertMode.NONE && this.localKnownColumnNames.contains(preparedColumnName) && columnName.sourceInfo.aliasOrNull != null) {
            DBPDataSource ds = this.request.getContext().getDataSource();
            String alias = DBUtils.getUnQuotedIdentifier((DBPDataSource)ds, (String)columnName.sourceInfo.aliasOrNull.getName()) + DBUtils.getUnQuotedIdentifier((DBPDataSource)ds, (String)preparedColumnName);
            suffix = this.prepareAliasPrefix() + this.convertCaseIfNeeded(DBUtils.getQuotedIdentifier((DBPDataSource)ds, (String)alias));
        } else {
            suffix = "";
        }
        if (columnName.absolute) {
            String prefix = columnName.sourceInfo.aliasOrNull != null ? columnName.sourceInfo.aliasOrNull.getName() + this.structSeparator : "";
            return prefix + preparedColumnName + (String)suffix;
        }
        return preparedColumnName + (String)suffix;
    }

    @NotNull
    public String visitTableName(@NotNull SQLQueryCompletionItem.SQLTableNameCompletionItem tableName) {
        Object suffix;
        DBSEntity object = tableName.table;
        if (this.queryCompletionContext.getInspectionResult().expectingTableSourceIntroduction && this.aliasMode != SQLTableAliasInsertMode.NONE) {
            SQLDialect sqlDialect = SQLUtils.getDialectFromObject((DBPObject)object);
            String alias = SQLUtils.generateEntityAlias((DBSEntity)object, s -> sqlDialect.getKeywordType(s) != null || this.queryCompletionContext.getAliasesInUse().contains(s) || this.queryCompletionContext.getDataContext() != null && this.queryCompletionContext.getDataContext().resolveSource(this.monitor, List.of(s)) != null);
            suffix = this.prepareAliasPrefix() + this.convertCaseIfNeeded(alias);
        } else {
            suffix = "";
        }
        return this.prepareObjectName((DBPNamedObject)object) + (String)suffix;
    }

    @NotNull
    private String prepareAliasPrefix() {
        return this.aliasMode == SQLTableAliasInsertMode.EXTENDED ? " " + SQLCompletionAnalyzer.convertKeywordCase((SQLCompletionRequest)this.request, (String)"as", (boolean)false) + " " : " ";
    }

    @NotNull
    public String visitReservedWord(@NotNull SQLQueryCompletionItem.SQLReservedWordCompletionItem reservedWord) {
        return SQLCompletionAnalyzer.convertKeywordCase((SQLCompletionRequest)this.request, (String)reservedWord.text, (boolean)false);
    }

    @NotNull
    public String visitNamedObject(@NotNull SQLQueryCompletionItem.SQLDbNamedObjectCompletionItem namedObject) {
        return this.prepareObjectName((DBPNamedObject)namedObject.object);
    }

    @NotNull
    private String prepareObjectName(@NotNull DBPNamedObject namedObject) {
        String name = this.request.getContext().isUseShortNames() ? DBUtils.getQuotedIdentifier((DBPNamedObject)namedObject) : (this.request.getContext().isUseFQNames() ? DBUtils.getObjectFullName((DBPNamedObject)namedObject, (DBPEvaluationContext)DBPEvaluationContext.DML) : DBUtils.getQuotedIdentifier((DBPNamedObject)namedObject));
        return this.convertCaseIfNeeded(name);
    }

    @NotNull
    private String convertCaseIfNeeded(@NotNull String name) {
        String result = this.request.getWordDetector().isQuoted(name) ? name : SQLCompletionAnalyzer.convertKeywordCase((SQLCompletionRequest)this.request, (String)name, (boolean)true);
        return result;
    }
}

