/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLSemanticErrorAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLProblemAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.util.AbstractSQLEditorTextHover;
import org.jkiss.utils.CommonUtils;

public class SQLAnnotationHover
extends AbstractSQLEditorTextHover
implements ITextHover,
IAnnotationHover,
ITextHoverExtension,
ITextHoverExtension2,
IAnnotationHoverExtension {
    private static final Log log = Log.getLog(SQLAnnotationHover.class);
    private SQLEditorBase editor;

    public SQLAnnotationHover(SQLEditorBase editor) {
        this.setEditor((IEditorPart)editor);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        try {
            int linePosition = sourceViewer.getDocument().getLineOffset(lineNumber);
            int lineLength = sourceViewer.getDocument().getLineLength(lineNumber);
            StringBuilder sb = new StringBuilder();
            Iterator ai = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (ai.hasNext()) {
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = sourceViewer.getAnnotationModel().getPosition(anno)) == null || !annoPosition.overlapsWith(linePosition, lineLength)) continue;
                sb.append(anno.getText()).append("; ");
            }
            return sb.isEmpty() ? null : sb.toString();
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return null;
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object hoverInfo2 = this.getHoverInfo2(textViewer, hoverRegion);
        return hoverInfo2 == null ? null : hoverInfo2.toString();
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        ArrayList<AnnotationHyperlinkInfo> links = new ArrayList<AnnotationHyperlinkInfo>();
        ISourceViewer sourceViewer = (ISourceViewer)textViewer;
        Iterator ai = sourceViewer.getAnnotationModel().getAnnotationIterator();
        while (ai.hasNext()) {
            Position annoPosition;
            Annotation anno = (Annotation)ai.next();
            if (!this.isSupportedAnnotation(anno) || (annoPosition = sourceViewer.getAnnotationModel().getPosition(anno)) == null || !annoPosition.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength())) continue;
            links.add(new AnnotationHyperlinkInfo(anno, annoPosition));
        }
        links.sort(Comparator.comparingInt(l -> l.getPosition().getOffset()));
        return links.isEmpty() ? null : links.toArray(AnnotationHyperlinkInfo[]::new);
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        Interval hoverInterval = new Interval(offset, offset);
        Interval resultInterval = null;
        IAnnotationModel annotationModel = ((ISourceViewer)textViewer).getAnnotationModel();
        if (annotationModel != null) {
            Iterator ai = annotationModel.getAnnotationIterator();
            while (ai.hasNext()) {
                Interval annoInterval;
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = annotationModel.getPosition(anno)) == null || !(annoInterval = new Interval(annoPosition.getOffset(), annoPosition.getOffset() + annoPosition.getLength())).properlyContains(hoverInterval)) continue;
                Interval interval = resultInterval = resultInterval == null ? annoInterval : resultInterval.union(annoInterval);
            }
        }
        return resultInterval == null ? null : new Region(resultInterval.a, resultInterval.length());
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
        try {
            IRegion lineRegion = sourceViewer.getDocument().getLineInformation(lineRange.getStartLine());
            return this.getHoverInfo2((ITextViewer)sourceViewer, lineRegion);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return null;
        }
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }

    public boolean canHandleMouseCursor() {
        return true;
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.editor = (SQLEditorBase)editor;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return shell -> new LinkListInformationControl(shell);
    }

    private boolean isSupportedAnnotation(Annotation anno) {
        return anno instanceof SpellingAnnotation || anno instanceof SQLProblemAnnotation || anno instanceof SQLSemanticErrorAnnotation;
    }

    private class AnnotationHyperlinkInfo {
        @NotNull
        private final Annotation annotation;
        @NotNull
        private final Position position;

        private AnnotationHyperlinkInfo(@NotNull Annotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }

        @NotNull
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @NotNull
        public Position getPosition() {
            return this.position;
        }

        public void open() {
            TextViewer textViewer = SQLAnnotationHover.this.editor.getTextViewer();
            if (textViewer != null && !this.position.isDeleted) {
                textViewer.setSelectedRange(this.position.getOffset(), this.position.getLength());
                textViewer.revealRange(this.position.getOffset(), this.position.getLength());
            }
        }
    }

    private class LinkListInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private Composite linksContainer;
        private int firstLinkOffset;

        public LinkListInformationControl(Shell parentShell) {
            super(parentShell, false);
            this.firstLinkOffset = -1;
            this.setBackgroundColor(new Color(255, 128, 128));
            this.create();
        }

        public void setInformation(String information) {
        }

        public void setInput(Object input) {
            AnnotationHyperlinkInfo[] hyperlinks;
            AnnotationHyperlinkInfo[] annotationHyperlinkInfoArray = hyperlinks = (AnnotationHyperlinkInfo[])input;
            int n = hyperlinks.length;
            int n2 = 0;
            while (n2 < n) {
                SQLSemanticErrorAnnotation s;
                String underlyingError;
                Composite linkContainer;
                final AnnotationHyperlinkInfo hyperlink = annotationHyperlinkInfoArray[n2];
                if (this.firstLinkOffset < 0) {
                    this.firstLinkOffset = hyperlink.getPosition().getOffset();
                }
                if (hyperlinks.length > 1) {
                    linkContainer = UIUtils.createComposite((Composite)this.linksContainer, (int)2);
                    Annotation annotation = hyperlink.getAnnotation();
                    if (annotation instanceof MarkerAnnotation) {
                        MarkerAnnotation ma = (MarkerAnnotation)annotation;
                        IMarker m = ma.getMarker();
                        try {
                            int n3;
                            Object object = m.getAttribute("severity");
                            if (object instanceof Integer) {
                                Integer n4 = (Integer)object;
                                n3 = n4;
                            } else {
                                n3 = 0;
                            }
                            int severity = n3;
                            DBIcon image = switch (severity) {
                                case 2 -> DBIcon.SMALL_ERROR;
                                case 1 -> DBIcon.SMALL_WARNING;
                                case 0 -> DBIcon.SMALL_INFO;
                                default -> DBIcon.SMALL_INFO;
                            };
                            UIUtils.createLabel((Composite)linkContainer, (DBPImage)image);
                        }
                        catch (CoreException e) {
                            log.error((Object)"Failed to obtain annotation marker icon", (Throwable)e);
                            UIUtils.createPlaceholder((Composite)linkContainer, (int)1);
                        }
                    } else {
                        UIUtils.createLabel((Composite)linkContainer, (DBPImage)DBIcon.SMALL_INFO);
                    }
                } else {
                    linkContainer = this.linksContainer;
                }
                Hyperlink link = new Hyperlink(linkContainer, 0);
                link.setText(hyperlink.getAnnotation().getText());
                link.setUnderlined(true);
                link.addHyperlinkListener(new IHyperlinkListener(){
                    private Point oldSelection = null;

                    public void linkEntered(HyperlinkEvent e) {
                        this.oldSelection = ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer() != null ? ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer().getSelectedRange() : null;
                        Position hyperlinkRegion = hyperlink.getPosition();
                        if (!hyperlinkRegion.isDeleted) {
                            ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer().setSelectedRange(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength());
                        }
                    }

                    public void linkExited(HyperlinkEvent e) {
                        if (this.oldSelection != null && ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer() != null) {
                            ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer().setSelectedRange(this.oldSelection.x, this.oldSelection.y);
                        }
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        hyperlink.open();
                    }
                });
                Annotation annotation = hyperlink.getAnnotation();
                if (annotation instanceof SQLSemanticErrorAnnotation && CommonUtils.isNotEmpty((String)(underlyingError = (s = (SQLSemanticErrorAnnotation)annotation).getUnderlyingErrorMessage()))) {
                    link.setToolTipText(underlyingError);
                }
                ++n2;
            }
            super.getShell().pack(true);
        }

        protected void createContent(Composite parent) {
            this.linksContainer = UIUtils.createComposite((Composite)parent, (int)1);
            this.linksContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        }

        public boolean hasContents() {
            return true;
        }

        public Point computeSizeHint() {
            Rectangle bounds = this.getBounds();
            return new Point(bounds.width, bounds.height);
        }

        public void setVisible(boolean visible) {
            if (visible && this.firstLinkOffset >= 0 && SQLAnnotationHover.this.editor.getDocument() != null && SQLAnnotationHover.this.editor.getTextViewer() != null) {
                try {
                    IRegion modelLineRange = SQLAnnotationHover.this.editor.getDocument().getLineInformationOfOffset(this.firstLinkOffset);
                    IRegion visualLineRange = SQLAnnotationHover.this.editor.getTextViewer().modelRange2WidgetRange(modelLineRange);
                    StyledText widget = SQLAnnotationHover.this.editor.getTextViewer().getTextWidget();
                    int offset = visualLineRange.getOffset();
                    Rectangle localLineBounds = widget.getTextBounds(offset, offset + visualLineRange.getLength() - 1);
                    Rectangle globalLineBounds = Geometry.toDisplay((Control)widget, (Rectangle)localLineBounds);
                    if (this.getBounds().intersects(globalLineBounds)) {
                        this.setLocation(new Point(this.getBounds().x, globalLineBounds.y + globalLineBounds.height));
                    }
                    super.getShell().pack(true);
                }
                catch (BadLocationException badLocationException) {}
            }
            super.setVisible(visible);
        }
    }
}

