/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.dpi.model.client.ConfigUtils;
import org.jkiss.dbeaver.model.app.DBPApplicationDesktop;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

class BundleProcessConfig {
    private static final Map<String, Integer> START_BUNDLES = Map.of("org.eclipse.osgi", -1, "org.eclipse.core.runtime", 4, "org.apache.felix.scr", 2, "org.eclipse.equinox.common", 2, "org.eclipse.equinox.event", 2, "org.eclipse.equinox.simpleconfigurator", 1, "org.eclipse.update.configurator", 10);
    private final Map<String, ModuleWiring> dependencies = new LinkedHashMap<String, ModuleWiring>();
    private final Path dataPath;
    private Path configurationFolder;
    private Path workspaceDir;
    private Path devPropsFile;
    private int serverPort;

    public BundleProcessConfig(DBRProgressMonitor monitor, String processId) throws IOException {
        this.dataPath = DBWorkbench.getPlatform().getTempFolder(monitor, "dpi").resolve(processId);
        if (!Files.exists(this.dataPath, new LinkOption[0])) {
            Files.createDirectories(this.dataPath, new FileAttribute[0]);
        }
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public Path getConfigurationFolder() {
        return this.configurationFolder;
    }

    public Path getWorkspaceDir() {
        return this.workspaceDir;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    void generateApplicationConfiguration() throws IOException {
        this.configurationFolder = this.dataPath.resolve("configuration");
        if (!Files.exists(this.configurationFolder, new LinkOption[0])) {
            Files.createDirectories(this.configurationFolder, new FileAttribute[0]);
        }
        Path configIniFile = this.configurationFolder.resolve("config.ini");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (BufferedWriter out = Files.newBufferedWriter(configIniFile, StandardOpenOption.CREATE);){
            ConfigUtils.storeProperties(out, this.generateConfigIni());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Map<String, String> devProps = this.generateDevProps();
        if (!CommonUtils.isEmpty(devProps)) {
            this.devPropsFile = this.configurationFolder.resolve("dev.properties");
            throwable2 = null;
            Object var4_7 = null;
            try (BufferedWriter out = Files.newBufferedWriter(this.devPropsFile, StandardOpenOption.CREATE);){
                ConfigUtils.storeProperties(out, devProps);
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        this.workspaceDir = DBWorkbench.getPlatform().getWorkspace().getAbsolutePath();
    }

    private Map<String, String> generateDevProps() throws IOException {
        LinkedHashMap<Path, ModuleWiring> devFolders = new LinkedHashMap<Path, ModuleWiring>();
        for (ModuleWiring wire : this.dependencies.values()) {
            String bundleReference = this.getBundleReference(wire, false);
            Path bundlePath = Path.of(bundleReference, new String[0]);
            if (!Files.isDirectory(bundlePath, new LinkOption[0])) continue;
            devFolders.put(bundlePath, wire);
        }
        if (devFolders.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> devProps = new LinkedHashMap<String, String>();
        for (Map.Entry devInfo : devFolders.entrySet()) {
            String bundleId = ((ModuleWiring)devInfo.getValue()).getBundle().getSymbolicName();
            String bundleLibPath = "target/classes";
            devProps.put(bundleId, bundleLibPath);
        }
        return devProps;
    }

    private Map<String, String> generateConfigIni() throws IOException {
        URL installPathURL = Platform.getInstallLocation().getURL();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("osgi.install.area", BundleProcessConfig.getNormalizeFileReference(installPathURL.toString()));
        result.put("osgi.bundles.defaultStartLevel", "4");
        result.put("osgi.configuration.cascaded", Boolean.FALSE.toString());
        result.put("osgi.bundles", this.dependencies.values().stream().map(this::getBundleReference).collect(Collectors.joining(",")));
        ModuleWiring osgiWiring = this.dependencies.get("org.eclipse.osgi");
        if (osgiWiring != null) {
            result.put("osgi.framework", "file:" + this.getBundleReference(osgiWiring, false));
        }
        result.put("eclipse.noRegistryCache", "true");
        return result;
    }

    private String getBundleReference(ModuleWiring wiring) {
        return this.getBundleReference(wiring, true);
    }

    private String getBundleReference(ModuleWiring wiring, boolean reference) {
        String symbolicName = wiring.getBundle().getSymbolicName();
        Object revisionInfo = wiring.getResource().getRevisionInfo();
        if (revisionInfo instanceof BundleInfo.Generation) {
            BundleFile bundleFile = ((BundleInfo.Generation)revisionInfo).getBundleFile();
            File baseFile = bundleFile.getBaseFile();
            Object startLevel = "";
            if (START_BUNDLES.containsKey(symbolicName)) {
                startLevel = "@" + String.valueOf(START_BUNDLES.get(symbolicName)) + ":start";
            }
            String jarPath = BundleProcessConfig.fixWindowsPath(baseFile.getAbsoluteFile().getAbsolutePath());
            if (reference) {
                return "reference:file:" + jarPath + (String)startLevel;
            }
            return jarPath;
        }
        return BundleProcessConfig.fixWindowsPath(wiring.getBundle().getLocation());
    }

    public boolean isValid() {
        return !this.dependencies.isEmpty();
    }

    public boolean containsWiring(ModuleWiring wiring) {
        return this.dependencies.containsKey(wiring.getBundle().getSymbolicName());
    }

    public void addWiring(ModuleWiring wiring) {
        this.dependencies.put(wiring.getBundle().getSymbolicName(), wiring);
    }

    private static String fixWindowsPath(String path) {
        return path.replace('\\', '/');
    }

    private static String getNormalizeFileReference(@NotNull String path) {
        if ((path = BundleProcessConfig.fixWindowsPath(path)).startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.startsWith("file:")) {
            return "file:" + path;
        }
        return path;
    }

    public Process startProcess() throws IOException {
        String debugParams;
        ArrayList<String> cmd = new ArrayList<String>();
        String javaExePath = this.resolveJavaExePath();
        cmd.add(javaExePath);
        String launcherApp = "org.eclipse.equinox.launcher.Main";
        ModuleWiring launcherWiring = this.dependencies.get("org.jkiss.dbeaver.launcher");
        if (launcherWiring != null) {
            Object bundleReference = this.getBundleReference(launcherWiring, false);
            if (Files.isDirectory(Path.of((String)bundleReference, new String[0]), new LinkOption[0])) {
                bundleReference = (String)bundleReference + "/target/classes";
            }
            if (Files.exists(Path.of((String)bundleReference, new String[0]), new LinkOption[0])) {
                cmd.add("-cp");
                cmd.add((String)bundleReference);
                launcherApp = "org.jkiss.dbeaver.launcher.DBeaverLauncher";
            }
        }
        if (CommonUtils.isNotEmpty((String)(debugParams = System.getProperty("dbeaver.debug.dpi.launch.parameters")))) {
            cmd.add(debugParams);
        }
        cmd.add(launcherApp);
        cmd.add("-application");
        cmd.add("org.jkiss.dbeaver.dpi.app.application");
        cmd.add("-configuration");
        cmd.add("file:" + this.configurationFolder.toString());
        if (this.devPropsFile != null) {
            cmd.add("-dev");
            cmd.add("file:" + String.valueOf(this.devPropsFile));
        }
        cmd.add("-data");
        cmd.add(this.workspaceDir.toString());
        cmd.add("-envVariablesEnabled");
        cmd.add(String.valueOf(DBWorkbench.getPlatform().getApplication() instanceof DBPApplicationDesktop));
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(this.dataPath.toFile());
        pb.command(cmd);
        pb.inheritIO();
        return pb.start();
    }

    private String resolveJavaExePath() throws IOException {
        String javaExePath = System.getProperty("sun.boot.library.path");
        Path javaInstallationDir = Path.of(javaExePath, new String[0]);
        Path exePath = javaInstallationDir.resolve("java");
        if (Files.exists(exePath, new LinkOption[0])) {
            return exePath.toString();
        }
        exePath = javaInstallationDir.getParent().resolve("bin/java");
        if (Files.exists(exePath, new LinkOption[0])) {
            return exePath.toString();
        }
        exePath = javaInstallationDir.getParent().resolve("bin/java.exe");
        if (Files.exists(exePath, new LinkOption[0])) {
            return exePath.toString();
        }
        throw new IOException("Java exe not found");
    }
}

