/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;

public class DBDPseudoAttribute
implements DBPNamedObject {
    private final DBDPseudoAttributeType type;
    private final String name;
    private final String queryExpression;
    private final String alias;
    private final String description;
    private final boolean autoGenerated;

    public DBDPseudoAttribute(DBDPseudoAttributeType type, String name, String queryExpression, @Nullable String alias, String description, boolean autoGenerated) {
        this.type = type;
        this.name = name;
        this.queryExpression = queryExpression;
        this.alias = alias;
        this.description = description;
        this.autoGenerated = autoGenerated;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public DBDPseudoAttributeType getType() {
        return this.type;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public String getQueryExpression() {
        return this.queryExpression;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public String translateExpression(String tableAlias) {
        return this.queryExpression.replace("$alias", tableAlias);
    }

    public String toString() {
        return this.name + " (" + String.valueOf((Object)this.type) + ")";
    }

    public DBSEntityAttribute createFakeAttribute(DBSEntity owner, DBCAttributeMetaData attribute) {
        return new FakeEntityAttribute(owner, attribute);
    }

    @Nullable
    public static DBDPseudoAttribute getAttribute(DBDPseudoAttribute[] attributes, DBDPseudoAttributeType type) {
        if (attributes == null || attributes.length == 0) {
            return null;
        }
        DBDPseudoAttribute[] dBDPseudoAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDPseudoAttribute attribute = dBDPseudoAttributeArray[n2];
            if (attribute.getType() == type) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    private class FakeEntityAttribute
    implements DBSEntityAttribute,
    DBPQualifiedObject {
        private DBSEntity owner;
        private DBCAttributeMetaData attribute;

        public FakeEntityAttribute(DBSEntity owner, DBCAttributeMetaData attribute) {
            this.owner = owner;
            this.attribute = attribute;
        }

        @Override
        public boolean isAutoGenerated() {
            return DBDPseudoAttribute.this.autoGenerated;
        }

        @Override
        public int getOrdinalPosition() {
            return this.attribute.getOrdinalPosition();
        }

        @Override
        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @Override
        @NotNull
        public DBSEntity getParentObject() {
            return this.owner;
        }

        @Override
        @Nullable
        public String getDescription() {
            return DBDPseudoAttribute.this.description;
        }

        @Override
        @NotNull
        public DBPDataSource getDataSource() {
            return this.owner.getDataSource();
        }

        @Override
        @NotNull
        public String getName() {
            return DBDPseudoAttribute.this.name;
        }

        @Override
        public boolean isPersisted() {
            return true;
        }

        @Override
        public boolean isRequired() {
            return this.attribute.isRequired();
        }

        @Override
        @NotNull
        public String getTypeName() {
            return this.attribute.getTypeName();
        }

        @Override
        @NotNull
        public String getFullTypeName() {
            return this.attribute.getFullTypeName();
        }

        @Override
        public int getTypeID() {
            return this.attribute.getTypeID();
        }

        @Override
        @NotNull
        public DBPDataKind getDataKind() {
            return this.attribute.getDataKind();
        }

        @Override
        @Nullable
        public Integer getScale() {
            return this.attribute.getScale();
        }

        @Override
        public Integer getPrecision() {
            return this.attribute.getPrecision();
        }

        @Override
        public long getMaxLength() {
            return this.attribute.getMaxLength();
        }

        @Override
        public long getTypeModifiers() {
            return this.attribute.getTypeModifiers();
        }

        @Override
        @NotNull
        public String getFullyQualifiedName(DBPEvaluationContext context) {
            return DBDPseudoAttribute.this.name;
        }
    }
}

