/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.impl.sql.AbstractSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.RelationalSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLStateType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class BasicSQLDialect
extends AbstractSQLDialect
implements RelationalSQLDialect {
    public static final String ID = "basic";
    public static final BasicSQLDialect INSTANCE = new BasicSQLDialect();
    private static final String[] DEFAULT_LINE_COMMENTS = new String[]{"--"};
    private static final String[] EXEC_KEYWORDS = new String[0];
    private static final String[] DDL_KEYWORDS = new String[]{"CREATE", "ALTER", "DROP"};
    private static final String[][] DEFAULT_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}};
    protected static final String[] NON_TRANSACTIONAL_KEYWORDS = new String[]{"SELECT", "EXPLAIN", "DESCRIBE", "DESC", "USE", "SET", "COMMIT", "ROLLBACK"};
    private static final String[] CORE_NON_TRANSACTIONAL_KEYWORDS = new String[]{"SELECT"};
    protected static final String[] DML_KEYWORDS = new String[]{"INSERT", "DELETE", "UPDATE", "MERGE", "UPSERT", "TRUNCATE"};
    public static final String[][] DEFAULT_IDENTIFIER_QUOTES = new String[][]{{"\"", "\""}};
    public static final String[][] DEFAULT_STRING_QUOTES = new String[][]{{"'", "'"}};
    private static final String[] COMMIT_KEYWORDS = new String[]{"COMMIT"};
    private static final String[] ROLLBACK_KEYWORDS = new String[]{"ROLLBACK"};

    protected BasicSQLDialect() {
        this.loadStandardKeywords();
    }

    @Override
    @NotNull
    public String getDialectId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDialectName() {
        return "SQL";
    }

    @Override
    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_IDENTIFIER_QUOTES;
    }

    @Override
    @NotNull
    public String[][] getStringQuoteStrings() {
        return DEFAULT_STRING_QUOTES;
    }

    @Override
    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @Override
    @NotNull
    public String[] getDDLKeywords() {
        return DDL_KEYWORDS;
    }

    @Override
    @NotNull
    public String getSearchStringEscape() {
        return "";
    }

    @Override
    public char getStringEscapeCharacter() {
        return '\u0000';
    }

    @Override
    public int getCatalogUsage() {
        return 0;
    }

    @Override
    public int getSchemaUsage() {
        return 0;
    }

    @Override
    @NotNull
    public String getCatalogSeparator() {
        return String.valueOf('.');
    }

    @Override
    public char getStructSeparator() {
        return '.';
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    @NotNull
    public SQLStateType getSQLStateType() {
        return SQLStateType.SQL99;
    }

    @Override
    @Nullable
    public String getScriptDelimiterRedefiner() {
        return null;
    }

    @Override
    public String[][] getBlockBoundStrings() {
        return DEFAULT_BEGIN_END_BLOCK;
    }

    @Override
    @Nullable
    public String[] getBlockHeaderStrings() {
        return null;
    }

    @Override
    public boolean validIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    @Override
    public boolean supportsUnquotedMixedCase() {
        return true;
    }

    @Override
    public boolean supportsQuotedMixedCase() {
        return true;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.UPPER;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesQuotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    @Override
    @NotNull
    public String escapeString(String string) {
        return string.replace("'", "''");
    }

    @Override
    @NotNull
    public String unEscapeString(String string) {
        return CommonUtils.notEmpty((String)string).replace("''", "'");
    }

    @Override
    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof UUID) {
            return "'" + this.escapeString(strValue) + "'";
        }
        return strValue;
    }

    @Override
    public boolean supportsSubqueries() {
        return true;
    }

    @Override
    public boolean supportsAliasInSelect() {
        return false;
    }

    @Override
    public boolean supportsAliasInUpdate() {
        return false;
    }

    @Override
    public boolean supportsTableDropCascade() {
        return false;
    }

    @Override
    public boolean supportsOrderByIndex() {
        return true;
    }

    @Override
    public boolean supportsOrderBy() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsCommentQuery() {
        return false;
    }

    @Override
    public boolean supportsNullability() {
        return true;
    }

    @Override
    public String[] getSingleLineComments() {
        return DEFAULT_LINE_COMMENTS;
    }

    @Override
    public boolean isDelimiterAfterQuery() {
        return false;
    }

    @Override
    public boolean isDelimiterAfterBlock() {
        return false;
    }

    @Override
    @Nullable
    public String[] getTransactionCommitKeywords() {
        return COMMIT_KEYWORDS;
    }

    @Override
    @Nullable
    public String[] getTransactionRollbackKeywords() {
        return ROLLBACK_KEYWORDS;
    }

    @Override
    protected boolean isTransactionModifyingKeyword(String firstKeyword) {
        return "DO".equals(firstKeyword) || super.isTransactionModifyingKeyword(firstKeyword);
    }

    @Override
    @NotNull
    public String[] getDMLKeywords() {
        return this.isStandardSQL() ? DML_KEYWORDS : new String[]{};
    }

    @Override
    @NotNull
    public String[] getNonTransactionKeywords() {
        return this.isStandardSQL() ? NON_TRANSACTIONAL_KEYWORDS : CORE_NON_TRANSACTIONAL_KEYWORDS;
    }

    @Override
    public boolean isQuoteReservedWords() {
        return true;
    }

    @Override
    public boolean isCRLFBroken() {
        return false;
    }

    @Override
    public boolean isStandardSQL() {
        return true;
    }

    @Override
    public boolean isAmbiguousCountBroken() {
        return false;
    }

    private void loadStandardKeywords() {
        HashSet<String> all = new HashSet<String>();
        if (this.isStandardSQL()) {
            Collections.addAll(all, SQLConstants.SQL2003_RESERVED_KEYWORDS);
            Collections.addAll(all, SQLConstants.SQL_EX_KEYWORDS);
            this.addFunctions(List.of(SQLConstants.SQL2003_FUNCTIONS));
            this.addTableQueryKeywords(SQLConstants.TABLE_KEYWORDS);
            this.addColumnQueryKeywords(SQLConstants.COLUMN_KEYWORDS);
        }
        for (String executeKeyword : ArrayUtils.safeArray((Object[])this.getExecuteKeywords())) {
            this.addSQLKeyword(executeKeyword);
            this.setKeywordIndent(executeKeyword, 1);
        }
        for (String ddlKeyword : ArrayUtils.safeArray((Object[])this.getDDLKeywords())) {
            this.addSQLKeyword(ddlKeyword);
            this.setKeywordIndent(ddlKeyword, 1);
        }
        for (String kw : this.getTableQueryWords()) {
            this.setKeywordIndent(kw, 1);
        }
        for (String kw : this.getColumnQueryWords()) {
            this.setKeywordIndent(kw, 1);
        }
        for (String[] beKeywords : ArrayUtils.safeArray((Object[])this.getBlockBoundStrings())) {
            this.setKeywordIndent(beKeywords[0], 1);
            this.setKeywordIndent(beKeywords[1], -1);
        }
        if (this.isStandardSQL()) {
            if (this.needsDefaultDataTypes()) {
                this.addDataTypes(List.of(SQLConstants.DEFAULT_TYPES));
            }
            this.addKeywords(all, DBPKeywordType.KEYWORD);
        }
    }

    public boolean needsDefaultDataTypes() {
        return true;
    }
}

