/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.jexl3.JexlContext;
import org.eclipse.core.resources.IResource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPObjectWithOrdinalPosition;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNUtils {
    private static final Log log = Log.getLog(DBNUtils.class);

    public static DBNDatabaseNode getNodeByObject(DBSObject object) {
        DBNModel model = DBNUtils.getNavigatorModel(object);
        return model == null ? null : model.getNodeByObject(object);
    }

    @Nullable
    public static DBNModel getNavigatorModel(DBSObject object) {
        DBPProject project = DBUtils.getObjectOwnerProject(object);
        if (project == null) {
            return null;
        }
        return project.getNavigatorModel();
    }

    public static DBNDatabaseNode getNodeByObject(DBRProgressMonitor monitor, DBSObject object, boolean addFiltered) {
        DBNModel model = DBNUtils.getNavigatorModel(object);
        return model == null ? null : model.getNodeByObject(monitor, object, addFiltered);
    }

    public static DBNDatabaseNode getChildFolder(DBRProgressMonitor monitor, DBNDatabaseNode node, Class<?> folderType) {
        try {
            DBNDatabaseNode[] dBNDatabaseNodeArray = node.getChildren(monitor);
            int n = dBNDatabaseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> objectClass;
                DBXTreeFolder meta;
                DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
                if (childNode instanceof DBNDatabaseFolder && !CommonUtils.isEmpty((String)(meta = ((DBNDatabaseFolder)childNode).getMeta()).getType()) && (objectClass = meta.getSource().getObjectClass(meta.getType())) != null && folderType.isAssignableFrom(objectClass)) {
                    return childNode;
                }
                ++n2;
            }
        }
        catch (DBException e) {
            log.error("Error reading child folder", e);
        }
        return null;
    }

    public static DBNNode[] getNodeChildrenFiltered(DBRProgressMonitor monitor, DBNNode node, boolean forTree) throws DBException {
        DBNNode[] children = node.getChildren(monitor);
        if (children != null && children.length > 0) {
            children = DBNUtils.filterNavigableChildren(children, forTree);
        }
        return children;
    }

    public static DBNNode[] filterNavigableChildren(DBNNode[] children, boolean forTree) {
        DBNNode[] result;
        if (ArrayUtils.isEmpty((Object[])children)) {
            return children;
        }
        if (forTree) {
            ArrayList<DBNNode> filtered = new ArrayList<DBNNode>();
            DBNNode[] dBNNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode dbNode;
                DBPHiddenObject hiddenObject;
                DBNNode node = dBNNodeArray[n2];
                if (!(node instanceof DBPHiddenObject && (hiddenObject = (DBPHiddenObject)((Object)node)).isHidden() || node instanceof DBNDatabaseNode && (dbNode = (DBNDatabaseNode)node).getMeta() != null && !dbNode.getMeta().isNavigable())) {
                    filtered.add(node);
                }
                ++n2;
            }
            result = filtered.toArray(new DBNNode[0]);
        } else {
            result = children;
        }
        DBNUtils.sortNodes(result);
        return result;
    }

    private static void sortNodes(DBNNode[] children) {
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (children.length > 0) {
            DBNNode firstChild = children[0];
            boolean isResources = firstChild instanceof DBNNodeWithResource;
            if (isResources) {
                Arrays.sort(children, NodeFolderComparator.INSTANCE);
            } else if (prefStore.getBoolean("navigator.sort.case.insensitive") || DBNUtils.isMergedEntity(firstChild)) {
                if (!(firstChild instanceof DBNContainer)) {
                    Arrays.sort(children, NodeNameComparator.INSTANCE);
                }
            } else if (prefStore.getBoolean("navigator.sort.forlers.first")) {
                Arrays.sort(children, NodeFolderComparator.INSTANCE);
            }
        }
    }

    private static boolean isMergedEntity(DBNNode node) {
        return node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof DBSEntity && ((DBNDatabaseNode)node).getObject().getDataSource().getContainer().getNavigatorSettings().isMergeEntities();
    }

    public static boolean isDefaultElement(Object element) {
        DBNProject nodeProject;
        if (element instanceof DBSWrapper) {
            DBCExecutionContextDefaults contextDefaults;
            DBCExecutionContext defaultContext;
            DBSObject object = ((DBSWrapper)element).getObject();
            if (object != null && (defaultContext = DBUtils.getDefaultContext(object.getDataSource(), false)) != null && (contextDefaults = defaultContext.getContextDefaults()) != null) {
                return Objects.equals(contextDefaults.getDefaultCatalog(), object) || Objects.equals(contextDefaults.getDefaultSchema(), object);
            }
        } else if (element instanceof DBNProject && (nodeProject = (DBNProject)element).getProject() == DBWorkbench.getPlatform().getWorkspace().getActiveProject()) {
            return true;
        }
        return false;
    }

    public static void refreshNavigatorResource(@NotNull DBPProject project, @NotNull IResource resource, Object source) {
        DBNResource fileNode;
        DBNModel navigatorModel = project.getNavigatorModel();
        if (navigatorModel == null) {
            return;
        }
        DBNProject projectNode = navigatorModel.getRoot().getProjectNode(resource.getProject());
        if (projectNode != null && (fileNode = projectNode.findResource(resource)) != null) {
            fileNode.refreshResourceState(source);
        }
    }

    @NotNull
    public static String getLastNodePathSegment(@NotNull String path) {
        int divPos = path.lastIndexOf(47);
        return divPos == -1 ? path : path.substring(divPos + 1);
    }

    public static boolean isReadOnly(DBNNode node) {
        return node instanceof DBNDatabaseNode && !(node instanceof DBNDataSource) && !((DBNDatabaseNode)node).getDataSourceContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA);
    }

    @Nullable
    public static <T> T getParentOfType(@NotNull Class<T> type, DBNNode node) {
        if (node == null) {
            return null;
        }
        DBNNode parent = node.getParentNode();
        while (parent != null) {
            if (type.isInstance(parent)) {
                return type.cast(parent);
            }
            if (parent instanceof DBNRoot) break;
            parent = parent.getParentNode();
        }
        return null;
    }

    public static JexlContext makeContext(final DBNNode node) {
        return new JexlContext(){

            public Object get(String name) {
                block14: {
                    if (!(node instanceof DBNDatabaseNode)) break block14;
                    switch (name) {
                        case "object": {
                            return ((DBNDatabaseNode)node).getValueObject();
                        }
                        case "dataSource": {
                            return ((DBNDatabaseNode)node).getDataSource();
                        }
                        case "connected": {
                            if (((DBNDatabaseNode)node).getDataSource() != null) {
                                return true;
                            }
                            return false;
                        }
                    }
                }
                return null;
            }

            public void set(String name, Object value) {
                log.warn("Set is not implemented in DBX model");
            }

            public boolean has(String name) {
                return node instanceof DBNDatabaseNode && name.equals("object") && ((DBNDatabaseNode)node).getValueObject() != null;
            }
        };
    }

    public static String decodeNodePath(@NotNull String nodePath) {
        return nodePath.replace("%2F", "/").replace("%25", "%");
    }

    public static String encodeNodePath(@NotNull String path) {
        return path.replace("%", "%25").replace("/", "%2F");
    }

    private static class NodeFolderComparator
    implements Comparator<DBNNode> {
        static NodeFolderComparator INSTANCE = new NodeFolderComparator();

        private NodeFolderComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            int first = NodeFolderComparator.isFolderNode(node1) ? -1 : 1;
            int second = NodeFolderComparator.isFolderNode(node2) ? -1 : 1;
            return first - second;
        }

        private static boolean isFolderNode(DBNNode node) {
            DBNDatabaseNode dbn;
            if (node instanceof DBNDatabaseNode && (dbn = (DBNDatabaseNode)node).getObject() instanceof DBPObjectWithOrdinalPosition) {
                return false;
            }
            return node instanceof DBNContainer || node.allowsChildren();
        }
    }

    private static class NodeNameComparator
    implements Comparator<DBNNode> {
        static NodeNameComparator INSTANCE = new NodeNameComparator();

        private NodeNameComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            return node1.getNodeDisplayName().compareToIgnoreCase(node2.getNodeDisplayName());
        }
    }
}

