/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.utils.CommonUtils;

public class DBWUtils {
    public static final String LOOPBACK_HOST_NAME = "127.0.0.1";
    public static final String LOOPBACK_IPV6_HOST_NAME = ":1";
    public static final String LOOPBACK_IPV6_FULL_HOST_NAME = "0:0:0:0:0:0:0:1";
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOCAL_NAME = "local";

    public static void updateConfigWithTunnelInfo(DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo, String localHost, int localPort) {
        if (CommonUtils.isEmpty((String)localHost)) {
            connectionInfo.setHostName(LOOPBACK_HOST_NAME);
        } else {
            connectionInfo.setHostName(localHost);
        }
        connectionInfo.setHostPort(Integer.toString(localPort));
        if (configuration.getDriver() != null) {
            String newURL = configuration.getDriver().getConnectionURL(connectionInfo);
            connectionInfo.setUrl(newURL);
        }
    }

    @NotNull
    public static String getTargetTunnelHostName(DBPConnectionConfiguration cfg) {
        String hostText = cfg.getHostName();
        if (DBWUtils.isLocalAddress(hostText)) {
            for (DBWHandlerConfiguration hc : cfg.getHandlers()) {
                String tunnelHost;
                if (!hc.isEnabled() || hc.getType() != DBWHandlerType.TUNNEL || CommonUtils.isEmpty((String)(tunnelHost = hc.getStringProperty("host")))) continue;
                hostText = tunnelHost;
                break;
            }
        }
        return CommonUtils.notEmpty((String)hostText);
    }

    public static boolean isLocalAddress(String hostText) {
        return CommonUtils.isEmpty((String)hostText) || hostText.equals(LOCALHOST_NAME) || hostText.equals(LOCAL_NAME) || hostText.equals(LOOPBACK_HOST_NAME) || hostText.equals(LOOPBACK_IPV6_HOST_NAME) || hostText.equals(LOOPBACK_IPV6_FULL_HOST_NAME);
    }
}

