/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.rm.RMControllerProvider;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectPermission;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class RMUtils {
    public static final String USER_PROJECTS_FOLDER = "user-projects";
    public static final String SHARED_PROJECTS_FOLDER = "shared-projects";

    public static java.nio.file.Path getRootPath() {
        return DBWorkbench.getPlatform().getWorkspace().getAbsolutePath();
    }

    public static java.nio.file.Path getUserProjectsPath() {
        return RMUtils.getRootPath().resolve(USER_PROJECTS_FOLDER);
    }

    public static java.nio.file.Path getSharedProjectsPath() {
        return RMUtils.getRootPath().resolve(SHARED_PROJECTS_FOLDER);
    }

    @NotNull
    public static java.nio.file.Path getProjectPath(RMProject project) {
        switch (project.getType()) {
            case GLOBAL: {
                return RMUtils.getRootPath().resolve(DBWorkbench.getPlatform().getApplication().getDefaultProjectName());
            }
            case SHARED: {
                return RMUtils.getSharedProjectsPath().resolve(project.getName());
            }
        }
        return RMUtils.getUserProjectsPath().resolve(project.getName());
    }

    public static String getProjectName(@NotNull String projectId) throws DBException {
        int divPos = projectId.indexOf("_");
        if (divPos <= 0) {
            throw new DBException("Bad project ID");
        }
        return projectId.substring(divPos + 1);
    }

    @NotNull
    public static java.nio.file.Path getProjectPathById(@NotNull String projectId) throws DBException {
        int divPos = projectId.indexOf("_");
        if (divPos <= 0) {
            throw new DBException("Bad project ID");
        }
        String prefix = projectId.substring(0, divPos);
        String projectName = projectId.substring(divPos + 1);
        switch (RMProjectType.getByPrefix(prefix)) {
            case GLOBAL: {
                String defaultProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
                if (CommonUtils.isEmpty((String)defaultProjectName)) {
                    throw new DBException("Global projects are not supported");
                }
                return RMUtils.getRootPath().resolve(defaultProjectName);
            }
            case SHARED: {
                return RMUtils.getSharedProjectsPath().resolve(projectName);
            }
        }
        return RMUtils.getUserProjectsPath().resolve(projectName);
    }

    public static Set<String> parseProjectPermissions(Set<String> permissions) {
        return permissions.stream().map(RMProjectPermission::fromPermission).filter(Objects::nonNull).flatMap(permission -> permission.getAllPermissions().stream()).collect(Collectors.toSet());
    }

    public static RMProject createAnonymousProject() {
        RMProject project = new RMProject("anonymous");
        project.setId("anonymous");
        project.setType(RMProjectType.USER);
        project.setProjectPermissions(RMProjectPermission.DATA_SOURCES_EDIT.getAllPermissions().toArray(new String[0]));
        return project;
    }

    /*
     * Loose catch block
     */
    public static String readScriptContents(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String filePath) throws DBException, IOException {
        java.nio.file.Path nioPath = DBFUtils.resolvePathFromString(monitor, project, filePath);
        if (!IOUtils.isLocalPath((java.nio.file.Path)nioPath)) {
            return Files.readString(nioPath);
        }
        RMControllerProvider rmControllerProvider = DBUtils.getAdapter(RMControllerProvider.class, project);
        if (rmControllerProvider != null) {
            RMController rmController = rmControllerProvider.getResourceController();
            return new String(rmController.getResourceContents(project.getId(), filePath), StandardCharsets.UTF_8);
        }
        IContainer projectRootResource = project.getRootResource();
        if (projectRootResource == null) {
            throw new DBException("Root resource is not found in project " + project.getId());
        }
        IFile sqlFile = RMUtils.findEclipseProjectFile(project, filePath);
        if (sqlFile == null) {
            throw new DBException("File " + filePath + " is not found in project " + project.getId());
        }
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (InputStream sqlStream = sqlFile.getContents(true);){
                String string;
                InputStreamReader fileReader;
                Throwable throwable2;
                block25: {
                    throwable2 = null;
                    Object var11_16 = null;
                    fileReader = new InputStreamReader(sqlStream, sqlFile.getCharset());
                    string = IOUtils.readToString((Reader)fileReader);
                    if (fileReader == null) break block25;
                    ((Reader)fileReader).close();
                }
                return string;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (fileReader != null) {
                                ((Reader)fileReader).close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public static IFile findEclipseProjectFile(@NotNull DBPProject project, @NotNull String filePath) {
        IContainer rootResource = project.getRootResource();
        if (rootResource == null) {
            return null;
        }
        IResource file = rootResource.findMember(filePath);
        if (file != null && file.exists() && file instanceof IFile) {
            return (IFile)file;
        }
        DBPWorkspace workspace = project.getWorkspace();
        if (workspace instanceof DBPWorkspaceEclipse && (file = ((DBPWorkspaceEclipse)workspace).getEclipseWorkspace().getRoot().getFile((IPath)new Path(filePath))).exists()) {
            return (IFile)file;
        }
        return null;
    }
}

