/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplicationWorkbench;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.impl.app.AbstractApplication;
import org.jkiss.dbeaver.runtime.ServiceRegistry;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DBWorkbench {
    private static final Log log = Log.getLog(DBWorkbench.class);
    private static DBPApplicationWorkbench applicationWorkbench;

    private static DBPApplicationWorkbench getApplicationWorkbench() {
        if (applicationWorkbench == null) {
            try {
                AbstractApplication.getInstance();
            }
            catch (Exception e) {
                log.debug("Error checking application instance", e);
            }
            applicationWorkbench = RuntimeUtils.getBundleService(DBPApplicationWorkbench.class, true);
        }
        return applicationWorkbench;
    }

    public static DBPPlatform getPlatform() {
        return DBWorkbench.getApplicationWorkbench().getPlatform();
    }

    public static <T extends DBPPlatform> T getPlatform(Class<T> pc) {
        return (T)((DBPPlatform)pc.cast(DBWorkbench.getPlatform()));
    }

    public static DBPPlatformUI getPlatformUI() {
        return DBWorkbench.getApplicationWorkbench().getPlatformUI();
    }

    @Nullable
    public static <T> T getService(@NotNull Class<T> serviceType) {
        T service = ServiceRegistry.getInstance().getService(serviceType);
        if (service == null) {
            log.debug("Service '" + serviceType.getName() + "' not found");
        }
        return service;
    }

    public static boolean isDistributed() {
        return DBWorkbench.getPlatform().getApplication().isDistributed();
    }

    public static boolean hasFeature(@NotNull String feature) {
        return DBWorkbench.getPlatform().getApplication().hasProductFeature(feature);
    }
}

