/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationDesktop;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.OperationSystemState;
import org.jkiss.dbeaver.runtime.jobs.DisconnectJob;
import org.jkiss.dbeaver.runtime.jobs.EndIdleTransactionsJob;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;
import org.jkiss.dbeaver.runtime.jobs.KeepAlivePingJob;

public class DataSourceMonitorJob
extends AbstractJob {
    private static final int MONITOR_INTERVAL = 3000;
    private static final Log log = Log.getLog(DataSourceMonitorJob.class);
    private static final int MAX_FAILED_ATTEMPTS_BEFORE_DISCONNECT = 5;
    private static final int MAX_FAILED_ATTEMPTS_BEFORE_IGNORE = 10;
    private static final boolean INVALIDATE_AFTER_SLEEP = true;
    private static final long SYSTEM_SUSPEND_INTERVAL = 20000L;
    private final DBPPlatform platform;
    private final Map<String, Long> checkCache = new HashMap<String, Long>();
    private final Set<String> pingCache = new HashSet<String>();
    private long lastPingTime = -1L;
    private boolean isSleeping = false;

    public DataSourceMonitorJob(DBPPlatform platform) {
        super("Connections monitoring");
        this.setUser(false);
        this.setSystem(true);
        this.platform = platform;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        if (this.platform.isShuttingDown()) {
            return Status.OK_STATUS;
        }
        boolean invalidateOnSleep = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("connection.closeOnSleep");
        boolean wasSleeping = this.isSleeping;
        this.isSleeping = OperationSystemState.isInSleepMode();
        if (!this.isSleeping) {
            if (invalidateOnSleep && this.lastPingTime > 0L && System.currentTimeMillis() - this.lastPingTime > 20000L) {
                this.invalidateSleptConnections(monitor);
            }
            this.doJob();
        } else if (!wasSleeping && invalidateOnSleep) {
            this.closeAllConnections(monitor);
        }
        this.lastPingTime = System.currentTimeMillis();
        if (!this.platform.isShuttingDown()) {
            this.scheduleMonitor();
        }
        return Status.OK_STATUS;
    }

    private void closeAllConnections(DBRProgressMonitor monitor) {
        log.debug("System suspend detected. Close all remote connections.");
        DBPWorkspace workspace = this.platform.getWorkspace();
        for (DBPProject dBPProject : new ArrayList<DBPProject>(workspace.getProjects())) {
            if (!dBPProject.isOpen() || !dBPProject.isRegistryLoaded()) continue;
            for (DBPDataSourceContainer dBPDataSourceContainer : dBPProject.getDataSourceRegistry().getDataSources()) {
                if (!dBPDataSourceContainer.isConnected() || dBPDataSourceContainer.getDriver().isEmbedded()) continue;
                log.debug("Close connection '" + dBPDataSourceContainer.getName() + "' for sleep mode");
                try {
                    dBPDataSourceContainer.disconnect(monitor);
                }
                catch (Exception exception) {
                    log.debug("Error closing connection in sleep mode");
                }
            }
        }
    }

    private void invalidateSleptConnections(DBRProgressMonitor monitor) {
        log.debug("System awake detected. Reinitialize all remote connections.");
        HashSet<DBPDataSource> invalidated = new HashSet<DBPDataSource>();
        DBPWorkspace workspace = this.platform.getWorkspace();
        for (DBPProject dBPProject : new ArrayList<DBPProject>(workspace.getProjects())) {
            if (!dBPProject.isOpen() || !dBPProject.isRegistryLoaded()) continue;
            DBPDataSourceRegistry dataSourceRegistry = dBPProject.getDataSourceRegistry();
            ArrayList<? extends DBPDataSourceContainer> dataSources = new ArrayList<DBPDataSourceContainer>(dataSourceRegistry.getDataSources());
            for (DBPDataSourceContainer dBPDataSourceContainer : dataSources) {
                DBPDataSource dataSource;
                if (!dBPDataSourceContainer.isConnected() || dBPDataSourceContainer.getDriver().isEmbedded() || (dataSource = dBPDataSourceContainer.getDataSource()) == null || invalidated.contains(dataSource)) continue;
                log.debug("Invalidate connection '" + dBPDataSourceContainer.getName() + "'");
                List<InvalidateJob.ContextInvalidateResult> results = InvalidateJob.invalidateDataSource(monitor, dataSource, true, true, null);
                for (InvalidateJob.ContextInvalidateResult result : results) {
                    invalidated.add(result.getDataSource());
                }
            }
        }
    }

    protected void doJob() {
        DBPWorkspace workspace = this.platform.getWorkspace();
        this.checkDataSourceAliveInWorkspace(workspace, DataSourceMonitorJob.getLastUserActivityTime(this.lastPingTime));
    }

    protected void checkDataSourceAliveInWorkspace(DBPWorkspace workspace, long lastUserActivityTime) {
        ArrayList<? extends DBPProject> projects = new ArrayList<DBPProject>(workspace.getProjects());
        for (DBPProject dBPProject : projects) {
            if (!dBPProject.isOpen() || !dBPProject.isRegistryLoaded()) continue;
            DBPDataSourceRegistry dataSourceRegistry = dBPProject.getDataSourceRegistry();
            ArrayList<? extends DBPDataSourceContainer> dataSources = new ArrayList<DBPDataSourceContainer>(dataSourceRegistry.getDataSources());
            for (DBPDataSourceContainer dBPDataSourceContainer : dataSources) {
                this.checkDataSourceAlive(dBPDataSourceContainer, lastUserActivityTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDataSourceAlive(DBPDataSourceContainer dataSourceDescriptor, long lastUserActivityTime) {
        Date connectTime;
        Long lastCheckTime;
        if (!dataSourceDescriptor.isConnected()) {
            return;
        }
        final String dsId = dataSourceDescriptor.getId();
        DataSourceMonitorJob dataSourceMonitorJob = this;
        synchronized (dataSourceMonitorJob) {
            if (this.pingCache.contains(dsId)) {
                return;
            }
        }
        if ((DataSourceMonitorJob.getDisconnectTimeoutSeconds(dataSourceDescriptor) > 0L || DataSourceMonitorJob.getTransactionTimeoutSeconds(dataSourceDescriptor) > 0L) && this.endIdleTransactionOrConnection(dataSourceDescriptor, lastUserActivityTime)) {
            return;
        }
        int keepAliveInterval = dataSourceDescriptor.getConnectionConfiguration().getKeepAliveInterval();
        if (keepAliveInterval <= 0) {
            return;
        }
        DBPDataSource dataSource = dataSourceDescriptor.getDataSource();
        if (dataSource == null) {
            return;
        }
        DataSourceMonitorJob dataSourceMonitorJob2 = this;
        synchronized (dataSourceMonitorJob2) {
            lastCheckTime = this.checkCache.get(dsId);
        }
        if (lastCheckTime == null && (connectTime = dataSourceDescriptor.getConnectTime()) != null) {
            lastCheckTime = connectTime.getTime();
        }
        if (lastCheckTime == null) {
            log.debug("Can't determine last check time for " + dsId);
            return;
        }
        long curTime = System.currentTimeMillis();
        if ((curTime - lastCheckTime) / 1000L > (long)keepAliveInterval) {
            boolean disconnectOnError = false;
            int failedAttemptCount = KeepAlivePingJob.getFailedAttemptCount(dataSource);
            if (failedAttemptCount >= 10) {
                return;
            }
            if (failedAttemptCount > 5) {
                disconnectOnError = true;
            }
            KeepAlivePingJob pingJob = new KeepAlivePingJob(dataSource, disconnectOnError);
            pingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    DataSourceMonitorJob dataSourceMonitorJob = DataSourceMonitorJob.this;
                    synchronized (dataSourceMonitorJob) {
                        DataSourceMonitorJob.this.checkCache.put(dsId, System.currentTimeMillis());
                        DataSourceMonitorJob.this.pingCache.remove(dsId);
                    }
                }
            });
            DataSourceMonitorJob dataSourceMonitorJob3 = this;
            synchronized (dataSourceMonitorJob3) {
                this.pingCache.add(dsId);
            }
            pingJob.schedule();
        }
    }

    private boolean endIdleTransactionOrConnection(DBPDataSourceContainer dsDescriptor, long lastUserActivityTime) {
        if (!dsDescriptor.isConnected()) {
            return false;
        }
        if (lastUserActivityTime < 0L) {
            return false;
        }
        long idleInterval = (System.currentTimeMillis() - lastUserActivityTime) / 1000L;
        long disconnectTimeoutSeconds = DataSourceMonitorJob.getDisconnectTimeoutSeconds(dsDescriptor);
        long rollbackTimeoutSeconds = DataSourceMonitorJob.getTransactionTimeoutSeconds(dsDescriptor);
        DBPDataSource dataSource = dsDescriptor.getDataSource();
        if (dataSource != null && disconnectTimeoutSeconds > 0L && idleInterval > disconnectTimeoutSeconds) {
            if (DisconnectJob.isInProcess(dsDescriptor)) {
                return false;
            }
            DisconnectJob disconnectJob = new DisconnectJob(dsDescriptor);
            disconnectJob.schedule();
            this.showNotification(dataSource);
            return true;
        }
        if (dataSource != null && rollbackTimeoutSeconds > 0L && idleInterval > rollbackTimeoutSeconds) {
            if (EndIdleTransactionsJob.isInProcess(dsDescriptor) || DBExecUtils.isExecutionInProgress(dataSource)) {
                return false;
            }
            try {
                IdentityHashMap<DBCExecutionContext, DBCTransactionManager> txnToEnd = new IdentityHashMap<DBCExecutionContext, DBCTransactionManager>();
                for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
                    DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
                    int n = dBCExecutionContextArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        QMTransactionState txnState;
                        DBCTransactionManager txnManager;
                        DBCExecutionContext ec = dBCExecutionContextArray[n2];
                        if (ec.isConnected() && (txnManager = DBUtils.getTransactionManager(ec)) != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit() && (txnState = QMUtils.getTransactionState(ec)).getUpdateCount() > 0 && txnState.getTransactionStartTime() <= lastUserActivityTime) {
                            txnToEnd.put(ec, txnManager);
                        }
                        ++n2;
                    }
                }
                if (!txnToEnd.isEmpty()) {
                    new EndIdleTransactionsJob(dataSource, txnToEnd).schedule();
                }
            }
            catch (DBCException e) {
                log.error(e);
            }
            return true;
        }
        return false;
    }

    public void scheduleMonitor() {
        this.schedule(3000L);
    }

    public static long getDisconnectTimeoutSeconds(@NotNull DBPDataSourceContainer container) {
        DBPConnectionConfiguration config = container.getConnectionConfiguration();
        if (!config.isCloseIdleConnection()) {
            return 0L;
        }
        int timeout = config.getCloseIdleInterval();
        if (timeout > 0) {
            return timeout;
        }
        DBPConnectionType connectionType = config.getConnectionType();
        if (connectionType.isAutoCloseConnections()) {
            return connectionType.getCloseIdleConnectionPeriod();
        }
        return 0L;
    }

    public static long getTransactionTimeoutSeconds(@NotNull DBPDataSourceContainer container) {
        DBPConnectionType connectionType;
        DBPPreferenceStore pref = container.getPreferenceStore();
        DBPConnectionConfiguration config = container.getConnectionConfiguration();
        int ttlSeconds = 0;
        if (pref.contains("transaction.auto.close.enabled")) {
            ttlSeconds = pref.getInt("transaction.auto.close.ttl");
        }
        if (ttlSeconds == 0 && (connectionType = config.getConnectionType()).isAutoCloseTransactions()) {
            ttlSeconds = connectionType.getCloseIdleTransactionPeriod();
        }
        return Math.max(0, ttlSeconds);
    }

    public static long getLastUserActivityTime() {
        return DataSourceMonitorJob.getLastUserActivityTime(-1L);
    }

    public static long getLastUserActivityTime(long lastUserActivityTime) {
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationDesktop) {
            DBPApplicationDesktop app = (DBPApplicationDesktop)dBPApplication;
            lastUserActivityTime = app.getLastUserActivityTime();
        }
        return lastUserActivityTime;
    }

    protected void showNotification(@NotNull DBPDataSource dataSource) {
        DBeaverNotifications.showNotification(dataSource, "disconnect.idle", "Connection '" + dataSource.getContainer().getName() + "' has been closed after long idle period", DBPMessageType.ERROR);
    }
}

