/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.project.ProjectCreateData;
import org.jkiss.dbeaver.tools.project.ProjectCreateRemotePage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.preferences.WizardPrefPage;
import org.jkiss.dbeaver.ui.project.PrefPageProjectResourceSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ProjectCreateWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    private final ProjectCreateData data = new ProjectCreateData();
    private WizardPrefPage projectSettingsPage;
    private IProject project;
    private ProjectCreateRemotePage remoteProjectPage;

    public IProject getProject() {
        return this.project;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(UINavigatorMessages.dialog_project_create_wizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        if (DBWorkbench.isDistributed()) {
            this.remoteProjectPage = new ProjectCreateRemotePage("RemoteProjectCreate");
            this.addPage((IWizardPage)this.remoteProjectPage);
        } else {
            super.addPages();
            PrefPageProjectResourceSettings projectSettingsPref = new PrefPageProjectResourceSettings();
            this.projectSettingsPage = new WizardPrefPage((IPreferencePage)projectSettingsPref, "Resources", "Project resources");
            this.addPage((IWizardPage)this.projectSettingsPage);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardNewProjectCreationPage) {
            return this.projectSettingsPage;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        if (!DBWorkbench.getPlatform().getWorkspace().canManageProjects()) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.dialog_project_create_wizard_error_cannot_create, "You can't manage projects");
            return false;
        }
        if (DBWorkbench.isDistributed()) {
            try {
                DBPProject newProject = DBPPlatformDesktop.getInstance().getWorkspace().createProject(this.remoteProjectPage.getProjectName(), this.remoteProjectPage.getProjectDescription());
                this.project = newProject.getEclipseProject();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(UINavigatorMessages.dialog_project_create_wizard_error_cannot_create, UINavigatorMessages.dialog_project_create_wizard_error_cannot_create_message, (Throwable)e);
                return false;
            }
            return true;
        }
        if (super.performFinish()) {
            try {
                UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ProjectCreateWizard.this.project = ProjectCreateWizard.this.createProject(monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                DBWorkbench.getPlatformUI().showError(UINavigatorMessages.dialog_project_create_wizard_error_cannot_create, UINavigatorMessages.dialog_project_create_wizard_error_cannot_create_message, ex.getTargetException());
                return false;
            }
            return true;
        }
        return false;
    }

    private IProject createProject(DBRProgressMonitor monitor) throws CoreException {
        IProgressMonitor nestedMonitor = RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor);
        IProject project = this.getNewProject();
        IProjectDescription description = project.getDescription();
        if (!CommonUtils.isEmpty((String)this.data.getDescription())) {
            description.setComment(this.data.getDescription());
        }
        description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
        project.setDescription(description, nestedMonitor);
        if (!project.isOpen()) {
            project.open(nestedMonitor);
        }
        return project;
    }
}

