/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateBase;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerRefresh;
import org.jkiss.dbeaver.ui.navigator.dialogs.EditObjectFilterDialog;

public class NavigatorHandlerFilterConfig
extends NavigatorHandlerObjectCreateBase
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        if (node instanceof DBNDatabaseItem) {
            node = node.getParentNode();
        }
        if (node instanceof DBNDatabaseFolder) {
            NavigatorHandlerFilterConfig.configureFilters(HandlerUtil.getActiveShell((ExecutionEvent)event), node);
        }
        return null;
    }

    public static void configureFilters(Shell shell, DBNNode node) {
        DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
        DBXTreeItem itemsMeta = dbNode.getItemsMeta();
        if (itemsMeta != null) {
            DBSObjectFilter objectFilter = dbNode.getNodeFilter(itemsMeta, true);
            if (objectFilter == null) {
                objectFilter = new DBSObjectFilter();
            }
            DBPDataSourceRegistry dsRegistry = dbNode.getOwnerProject().getDataSourceRegistry();
            boolean globalFilter = dbNode.getValueObject() instanceof DBPDataSource;
            String parentName = "?";
            if (dbNode.getValueObject() instanceof DBSObject) {
                parentName = ((DBSObject)dbNode.getValueObject()).getName();
            }
            EditObjectFilterDialog dialog = new EditObjectFilterDialog(shell, dsRegistry, globalFilter ? "All " + node.getNodeTypeLabel() : node.getNodeTypeLabel() + " of " + parentName, objectFilter, globalFilter);
            switch (dialog.open()) {
                case 0: {
                    dbNode.setNodeFilter(itemsMeta, dialog.getFilter(), true);
                    NavigatorHandlerRefresh.refreshNavigator(Collections.singletonList(dbNode));
                    break;
                }
                case 1000: {
                    Class childrenClass = null;
                    if (dbNode instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)dbNode;
                        childrenClass = folder.getChildrenClass();
                    } else {
                        Object e;
                        List childMeta = dbNode.getMeta().getChildren((DBNNode)dbNode);
                        if (!childMeta.isEmpty() && (e = childMeta.get(0)) instanceof DBXTreeItem) {
                            DBXTreeItem item = (DBXTreeItem)e;
                            childrenClass = dbNode.getChildrenClass(item);
                        }
                    }
                    if (childrenClass == null) {
                        DBWorkbench.getPlatformUI().showMessageBox("Bad node", "Cannot use node '" + dbNode.getNodeUri() + "' for filters", true);
                        return;
                    }
                    objectFilter = dbNode.getDataSource().getContainer().getObjectFilter(childrenClass, null, true);
                    dialog = new EditObjectFilterDialog(shell, dsRegistry, "All " + node.getNodeTypeLabel(), objectFilter != null ? objectFilter : new DBSObjectFilter(), true);
                    if (dialog.open() != 0) break;
                    dbNode.getDataSource().getContainer().setObjectFilter(childrenClass, null, dialog.getFilter());
                    dbNode.getDataSource().getContainer().persistConfiguration();
                    NavigatorHandlerRefresh.refreshNavigator(Collections.singletonList(dbNode));
                }
            }
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        DBNNode node = NavigatorUtils.getSelectedNode(element);
        if (node instanceof DBNDatabaseItem) {
            node = node.getParentNode();
        }
        if (node != null) {
            element.setText(NLS.bind((String)UINavigatorMessages.actions_navigator_filter_objects, (Object)node.getNodeTypeLabel()));
        }
    }
}

