/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.ui.connector.ERDConnection;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.utils.ListNode;

public class ERDHighlightingManager {
    private static final Log log = Log.getLog(ERDHighlightingManager.class);
    @NotNull
    private final Map<IFigure, PartHighlighter> highlightedParts = new HashMap<IFigure, PartHighlighter>();

    @NotNull
    public ERDHighlightingHandle highlight(@NotNull IFigure part, @NotNull Color color) {
        return this.highlightedParts.computeIfAbsent(part, iFigure -> new PartHighlighter((IFigure)iFigure)).highlight(color);
    }

    @Nullable
    public ERDHighlightingHandle makeHighlightingGroupHandle(@Nullable ListNode<ERDHighlightingHandle> highlightings) {
        if (highlightings == null) {
            return null;
        }
        return () -> {
            for (ERDHighlightingHandle highlighting : highlightings) {
                highlighting.release();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ListNode<ERDHighlightingHandle> highlightRelatedAttributes(@NotNull AttributePart attributePart, @NotNull Color color) {
        AssociationPart associationPart;
        void entityPart;
        EditPart editPart = attributePart.getParent();
        if (!(editPart instanceof EntityPart)) {
            return null;
        }
        EntityPart entityPart2 = (EntityPart)editPart;
        ListNode highlightings = null;
        for (AssociationPart associationPart2 : attributePart.getAssociatingBySource()) {
            if (!associationPart2.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart2.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join(highlightings, this.highlightRelatedAttributes(associationPart2, color));
        }
        for (AssociationPart associationPart2 : attributePart.getAssociatingByTarget()) {
            if (!associationPart2.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart2.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart2, color));
        }
        if (highlightings == null) {
            for (AssociationPart connection : entityPart.getSourceConnections()) {
                if (!(connection instanceof AssociationPart) || !(associationPart = connection).getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
                highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart, color));
            }
        }
        if (highlightings == null) {
            for (AssociationPart connection : entityPart.getTargetConnections()) {
                if (!(connection instanceof AssociationPart) || !(associationPart = connection).getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
                highlightings = ListNode.join((ListNode)highlightings, this.highlightRelatedAttributes(associationPart, color));
            }
        }
        return highlightings;
    }

    @Nullable
    public ListNode<ERDHighlightingHandle> highlightRelatedAttributes(@NotNull AssociationPart associationPart, @NotNull Color color) {
        ListNode highlightings = null;
        EntityPart sourceEntityPart = null;
        EditPart editPart = associationPart.getSource();
        if (editPart instanceof EntityPart) {
            EntityPart entityPartFromSource;
            sourceEntityPart = entityPartFromSource = (EntityPart)editPart;
        } else {
            EditPart editPart2 = associationPart.getSource().getParent();
            if (editPart2 instanceof EntityPart) {
                EntityPart entityPartFromParent;
                sourceEntityPart = entityPartFromParent = (EntityPart)editPart2;
            }
        }
        List<AttributePart> sourcePartAttributes = this.getEntityAttributes(sourceEntityPart, associationPart.getAssociation().getSourceAttributes());
        for (AttributePart attrPart : sourcePartAttributes) {
            highlightings = ListNode.push(highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
        }
        EditPart editPart3 = associationPart.getSource();
        if (editPart3 instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)editPart3;
            for (AttributePart attrPart : this.getEntityAttributes(entityPart, associationPart.getAssociation().getSourceAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
            }
        }
        EntityPart targetEntityPart = null;
        EditPart editPart4 = associationPart.getTarget();
        if (editPart4 instanceof EntityPart) {
            EntityPart entityPartFromSource;
            targetEntityPart = entityPartFromSource = (EntityPart)editPart4;
        } else {
            EditPart editPart5 = associationPart.getTarget().getParent();
            if (editPart5 instanceof EntityPart) {
                EntityPart entityPartFromParent;
                targetEntityPart = entityPartFromParent = (EntityPart)editPart5;
            }
        }
        List<AttributePart> targetPartAttributes = this.getEntityAttributes(targetEntityPart, associationPart.getAssociation().getTargetAttributes());
        for (AttributePart attrPart : targetPartAttributes) {
            highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
        }
        EditPart editPart6 = associationPart.getTarget();
        if (editPart6 instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)editPart6;
            for (AttributePart attrPart : this.getEntityAttributes(entityPart, associationPart.getAssociation().getTargetAttributes())) {
                highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight((IFigure)attrPart.getFigure(), color));
            }
        }
        return highlightings;
    }

    @Nullable
    public ListNode<ERDHighlightingHandle> highlightAssociation(@Nullable ListNode<ERDHighlightingHandle> highlightings, @NotNull AssociationPart associationPart, @NotNull Color color) {
        Connection connection = associationPart.getConnectionFigure();
        if (connection instanceof ERDConnection) {
            ERDConnection erdConnection;
            erdConnection.setSelected(!(erdConnection = (ERDConnection)connection).isSelected());
        }
        highlightings = ListNode.push(highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        return highlightings;
    }

    @Nullable
    public ListNode<ERDHighlightingHandle> highlightAssociation(@Nullable ListNode<ERDHighlightingHandle> highlightings, @NotNull AttributePart attributePart, @NotNull Color color) {
        Object object;
        Object object2;
        List associatingBySource = attributePart.getAssociatingBySource();
        if ((associatingBySource == null || associatingBySource.isEmpty()) && (object2 = attributePart.getParent()) instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)object2;
            associatingBySource = entityPart.getSourceConnections();
        }
        for (AssociationPart associationPart : associatingBySource) {
            if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.push(highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        }
        List associatingByTarget = attributePart.getAssociatingByTarget();
        if ((associatingByTarget == null || associatingByTarget.isEmpty()) && (object = attributePart.getParent()) instanceof EntityPart) {
            EntityPart entityPart = (EntityPart)object;
            associatingByTarget = entityPart.getTargetConnections();
        }
        for (AssociationPart associationPart : associatingByTarget) {
            if (!associationPart.getAssociation().getSourceAttributes().contains(attributePart.getAttribute()) && !associationPart.getAssociation().getTargetAttributes().contains(attributePart.getAttribute())) continue;
            highlightings = ListNode.push((ListNode)highlightings, (Object)this.highlight(associationPart.getFigure(), color));
        }
        return highlightings;
    }

    @NotNull
    private List<AttributePart> getEntityAttributes(@NotNull EntityPart source, @NotNull List<ERDEntityAttribute> columns) {
        ArrayList<AttributePart> result = new ArrayList<AttributePart>(columns.size());
        for (Object attrPart : source.getChildren()) {
            if (!(attrPart instanceof AttributePart) || !columns.contains(((AttributePart)attrPart).getAttribute())) continue;
            result.add((AttributePart)attrPart);
        }
        return result;
    }

    private static final class HighlightingEntry {
        public final Color color;

        public HighlightingEntry(@NotNull Color color) {
            this.color = color;
        }
    }

    private final class PartHighlighter {
        @NotNull
        private final IFigure part;
        @NotNull
        private final Color originalColor;
        private final boolean originalOpaque;
        @NotNull
        private final LinkedList<HighlightingEntry> highlightings = new LinkedList();

        public PartHighlighter(IFigure part) {
            this.originalColor = part instanceof Connection ? part.getForegroundColor() : part.getBackgroundColor();
            this.originalOpaque = part.isOpaque();
            this.part = part;
        }

        private void refresh() {
            try {
                if (this.highlightings.isEmpty()) {
                    IFigure iFigure = this.part;
                    if (iFigure instanceof ERDConnection) {
                        ERDConnection connection = (ERDConnection)iFigure;
                        connection.setSelected(false);
                        this.part.setForegroundColor(this.originalColor);
                    } else {
                        this.part.setBackgroundColor(this.originalColor);
                    }
                    this.part.setOpaque(this.originalOpaque);
                } else {
                    IFigure iFigure = this.part;
                    if (iFigure instanceof ERDConnection) {
                        ERDConnection connection = (ERDConnection)iFigure;
                        connection.setSelected(true);
                        this.part.setForegroundColor(this.highlightings.getLast().color);
                    } else {
                        this.part.setBackgroundColor(this.highlightings.getLast().color);
                    }
                    this.part.setOpaque(true);
                }
                this.part.repaint();
            }
            catch (Throwable ex) {
                log.warn((Object)"Inconsistent highlighting management detected during figure props refresh.", ex);
            }
        }

        @NotNull
        public ERDHighlightingHandle highlight(@NotNull Color color) {
            HighlightingEntry entry = new HighlightingEntry(color);
            this.highlightings.addLast(entry);
            this.refresh();
            return () -> {
                this.highlightings.remove(entry);
                if (this.highlightings.isEmpty()) {
                    ERDHighlightingManager.this.highlightedParts.remove(this.part);
                }
                this.refresh();
            };
        }
    }
}

