/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndexColumn;
import org.jkiss.dbeaver.ext.hive.model.HiveIndex;
import org.jkiss.dbeaver.ext.hive.model.HiveTableColumn;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class HiveTable
extends GenericTable
implements DBPImageProvider,
DBPNamedObject2 {
    public final IndexCache indexCache = new IndexCache();

    public HiveTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    @Nullable
    public synchronized List<HiveTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAttributes(monitor);
    }

    public Collection<HiveIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.indexCache.clearCache();
        return super.refreshObject(monitor);
    }

    public boolean isIndexTable() {
        return this.getTableType().equals("INDEX_TABLE");
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (this.isIndexTable()) {
            return DBIcon.TREE_TABLE_INDEX;
        }
        return DBIcon.TREE_TABLE;
    }

    public boolean supportUniqueIndexes() {
        return false;
    }

    public Collection<DBSIndexType> getTableIndexTypes() {
        ArrayList<DBSIndexType> indexTypes = new ArrayList<DBSIndexType>();
        indexTypes.add(new DBSIndexType("COMPACT", "Compact"));
        indexTypes.add(new DBSIndexType("BITMAP", "Bitmap"));
        return indexTypes;
    }

    class IndexCache
    extends JDBCCompositeCache<GenericStructContainer, HiveTable, HiveIndex, GenericTableIndexColumn> {
        IndexCache() {
            super((JDBCStructCache)HiveTable.this.getCache(), HiveTable.class, (Object)"tab_name", (Object)"idx_name");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, GenericStructContainer owner, HiveTable forParent) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SHOW INDEX ON ?");
            if (forParent != null) {
                dbStat.setString(1, forParent.getName());
            }
            return dbStat;
        }

        @Nullable
        protected HiveIndex fetchObject(JDBCSession session, GenericStructContainer owner, HiveTable parent, String indexName, JDBCResultSet dbResult) {
            String hiveIndexName = CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"idx_name")).trim();
            String comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
            String indexType = CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"idx_type")).trim();
            String indexTableName = CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"idx_tab_name")).trim();
            try {
                HiveTable table = (HiveTable)owner.getTable(dbResult.getSession().getProgressMonitor(), indexTableName);
                return new HiveIndex(parent, hiveIndexName, true, comment, indexType, table);
            }
            catch (DBException e) {
                log.debug((Object)("Can't read table from index" + indexName), (Throwable)e);
                return new HiveIndex(parent, hiveIndexName, true, comment, indexType, null);
            }
        }

        @Nullable
        protected GenericTableIndexColumn[] fetchObjectRow(JDBCSession session, HiveTable parent, HiveIndex index, JDBCResultSet dbResult) throws DBException {
            String columnNames = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"col_names");
            ArrayList<GenericTableIndexColumn> indexColumns = new ArrayList<GenericTableIndexColumn>();
            if (columnNames != null) {
                if (columnNames.contains(",")) {
                    String[] indexColumnNames;
                    String[] stringArray = indexColumnNames = columnNames.split(",");
                    int n = indexColumnNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String column = stringArray[n2];
                        GenericTableColumn attribute = parent.getAttribute(session.getProgressMonitor(), column.trim());
                        if (attribute != null) {
                            indexColumns.add(new GenericTableIndexColumn((GenericTableIndex)index, attribute, attribute.getOrdinalPosition(), false));
                        }
                        ++n2;
                    }
                } else {
                    GenericTableColumn attribute = parent.getAttribute(session.getProgressMonitor(), columnNames.trim());
                    if (attribute != null) {
                        indexColumns.add(new GenericTableIndexColumn((GenericTableIndex)index, attribute, attribute.getOrdinalPosition(), false));
                    }
                }
            }
            return (GenericTableIndexColumn[])ArrayUtils.toArray(GenericTableIndexColumn.class, indexColumns);
        }

        protected void cacheChildren(DBRProgressMonitor monitor, HiveIndex index, List<GenericTableIndexColumn> rows) {
            index.setColumns(rows);
        }
    }
}

